/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo;

import java.util.Objects;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.annotations.GogoCommand;
import org.eclipse.sensinact.gateway.commands.gogo.ResourceType;
import org.eclipse.sensinact.gateway.commands.gogo.SensiNactCommandSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetCommands.class})
@GogoCommand(scope="sna", function={"get"})
public class GetCommands {
    @Reference
    private SensiNactCommandSession session;

    @Descriptor(value="Get the value of a resource.\n\n   This variant assumes that the type of the value is Object.\n")
    public String get(@Descriptor(value="the provider ID") String provider, @Descriptor(value="the service ID") String service, @Descriptor(value="the resource ID") String resource) {
        ResourceType type = new ResourceType();
        type.type = Object.class;
        return Objects.toString(this.get(provider, service, resource, type));
    }

    @Descriptor(value="Get the value of a resource.\n\n   This variant accepts a simplified type for convenience.\n")
    public <T> T get(@Descriptor(value="the provider ID") String provider, @Descriptor(value="the service ID") String service, @Descriptor(value="the resource ID") String resource, @Descriptor(value="the simplified type of the resource value to get (one of: String, Integer, int)") ResourceType<T> type) {
        return (T)this.session.get().getResourceValue(provider, service, resource, type.type);
    }

    @Descriptor(value="Get the value of a resource.\n\n   This variant requires the FQN of the value type (i.e. java.lang.String).\n")
    public <T> T get(@Descriptor(value="the provider ID") String provider, @Descriptor(value="the service ID") String service, @Descriptor(value="the resource ID") String resource, @Descriptor(value="the type of the resource value to get") Class<T> type) {
        return (T)this.session.get().getResourceValue(provider, service, resource, type);
    }
}

