/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.test.integration;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.northbound.query.api.AbstractQueryDTO;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.api.IQueryHandler;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;
import org.eclipse.sensinact.northbound.query.dto.query.QueryDescribeDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryGetDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryListDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ErrorResultDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeProviderDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListResourcesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListServicesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.query.test.integration.TestUtils;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class MissingEntityTest {
    private static final UserInfo USER = UserInfo.ANONYMOUS;
    private static final String PROVIDER = "QueryHandlerMissingSvcProvider";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final Integer VALUE = 42;
    SensiNactSession session;
    @InjectService
    DataUpdate push;
    @InjectService
    IQueryHandler handler;
    final TestUtils utils = new TestUtils();

    @BeforeEach
    void start(@InjectService SensiNactSessionManager sessionManager) throws InterruptedException {
        this.session = sessionManager.getDefaultSession(USER);
    }

    @Test
    void missingProvider() throws Exception {
        String missingProvider = "QueryHandlerMissingSvcProvider__missing__";
        SensinactPath rcPath = new SensinactPath("QueryHandlerMissingSvcProvider__missing__", SERVICE, RESOURCE);
        for (SensinactPath missingProviderPath : Arrays.asList(new SensinactPath("QueryHandlerMissingSvcProvider__missing__"), new SensinactPath("QueryHandlerMissingSvcProvider__missing__", SERVICE), rcPath)) {
            QueryDescribeDTO describeQuery = new QueryDescribeDTO();
            describeQuery.uri = missingProviderPath;
            AbstractResultDTO result = this.handler.handleQuery(this.session, (AbstractQueryDTO)describeQuery);
            Assertions.assertEquals((int)404, (int)result.statusCode);
            Assertions.assertEquals((Object)EResultType.ERROR, (Object)result.type);
            Assertions.assertNotNull((Object)result.error);
            if (rcPath.hasResource()) continue;
            QueryListDTO listQuery = new QueryListDTO();
            listQuery.uri = missingProviderPath;
            result = this.handler.handleQuery(this.session, (AbstractQueryDTO)listQuery);
            Assertions.assertEquals((int)404, (int)result.statusCode);
            Assertions.assertEquals((Object)EResultType.ERROR, (Object)result.type);
            Assertions.assertNotNull((Object)result.error);
        }
        QueryGetDTO getQuery = new QueryGetDTO();
        getQuery.uri = rcPath;
        AbstractResultDTO result = this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        Assertions.assertEquals((int)404, (int)result.statusCode);
        Assertions.assertEquals((Object)EResultType.ERROR, (Object)result.type);
        Assertions.assertNotNull((Object)result.error);
    }

    @Test
    void missingService() throws Exception {
        QueryListDTO listQuery;
        QueryDescribeDTO describeQuery;
        String provider_service = "QueryHandlerMissingSvcProviderService";
        GenericDto dto = this.utils.makeDto(provider_service, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        String missingService = "service__missing__";
        SensinactPath rcPath = new SensinactPath(provider_service, "service__missing__", RESOURCE);
        for (SensinactPath missingProviderPath : Arrays.asList(new SensinactPath(provider_service, "service__missing__"), rcPath)) {
            describeQuery = new QueryDescribeDTO();
            describeQuery.uri = missingProviderPath;
            AbstractResultDTO result = this.handler.handleQuery(this.session, (AbstractQueryDTO)describeQuery);
            Assertions.assertEquals((int)404, (int)result.statusCode);
            Assertions.assertEquals((Object)EResultType.ERROR, (Object)result.type);
            Assertions.assertNotNull((Object)result.error);
            if (rcPath.hasResource()) continue;
            listQuery = new QueryListDTO();
            listQuery.uri = missingProviderPath;
            result = this.handler.handleQuery(this.session, (AbstractQueryDTO)listQuery);
            Assertions.assertEquals((int)404, (int)result.statusCode);
            Assertions.assertEquals((Object)EResultType.ERROR, (Object)result.type);
            Assertions.assertNotNull((Object)result.error);
        }
        QueryGetDTO getQuery = new QueryGetDTO();
        getQuery.uri = rcPath;
        AbstractResultDTO result = this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        Assertions.assertEquals((int)404, (int)result.statusCode);
        Assertions.assertEquals((Object)EResultType.ERROR, (Object)result.type);
        Assertions.assertNotNull((Object)result.error);
        describeQuery = new QueryDescribeDTO();
        describeQuery.uri = new SensinactPath(provider_service);
        result = this.handler.handleQuery(this.session, (AbstractQueryDTO)describeQuery);
        Assertions.assertEquals((int)200, (int)result.statusCode);
        Assertions.assertEquals((Object)EResultType.DESCRIBE_PROVIDER, (Object)result.type);
        Assertions.assertNull((Object)result.error);
        ResponseDescribeProviderDTO provider = this.utils.convert((TypedResponse)result, ResponseDescribeProviderDTO.class);
        Assertions.assertEquals((Object)provider_service, (Object)provider.name);
        Assertions.assertFalse((boolean)provider.services.contains("service__missing__"), (String)"Missing service is registered");
        listQuery = new QueryListDTO();
        listQuery.uri = new SensinactPath(provider_service);
        result = this.handler.handleQuery(this.session, (AbstractQueryDTO)listQuery);
        Assertions.assertEquals((int)200, (int)result.statusCode);
        Assertions.assertEquals((Object)EResultType.SERVICES_LIST, (Object)result.type);
        Assertions.assertNull((Object)result.error);
        ResultListServicesDTO svcListResult = (ResultListServicesDTO)result;
        Assertions.assertEquals((int)200, (int)svcListResult.statusCode);
        Assertions.assertFalse((boolean)svcListResult.services.contains("service__missing__"), (String)"Missing service is registered");
    }

    @Test
    void missingResource() throws Exception {
        String provider_resource = "QueryHandlerMissingSvcProvider_resource";
        GenericDto dto = this.utils.makeDto(provider_resource, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        String missingResource = "resource__missing__";
        QueryListDTO listQuery = new QueryListDTO();
        listQuery.uri = new SensinactPath(provider_resource, SERVICE);
        ResultListResourcesDTO rcListResult = (ResultListResourcesDTO)this.handler.handleQuery(this.session, (AbstractQueryDTO)listQuery);
        Assertions.assertEquals((int)200, (int)rcListResult.statusCode);
        Assertions.assertFalse((boolean)rcListResult.resources.contains("resource__missing__"), (String)"Missing resource is registered");
        QueryGetDTO getQuery = new QueryGetDTO();
        getQuery.uri = new SensinactPath(provider_resource, SERVICE, "resource__missing__");
        ErrorResultDTO result = (ErrorResultDTO)this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        Assertions.assertEquals((int)404, (int)result.statusCode);
        Assertions.assertNotNull((Object)result.error, (String)"No warning message set");
        Assertions.assertFalse((boolean)result.error.isEmpty(), (String)"No warning message set");
    }

    @Test
    void unsetResource() throws Exception {
        String provider2 = "QueryHandlerMissingSvcProvider_2";
        BulkGenericDto dto = new BulkGenericDto();
        dto.dtos = List.of(this.utils.makeDto("model", PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class), this.utils.makeDto("model", provider2, "admin", "friendlyName", "test", String.class));
        this.push.pushUpdate((Object)dto).getValue();
        QueryListDTO listQuery = new QueryListDTO();
        listQuery.uri = new SensinactPath(PROVIDER, SERVICE);
        ResultListResourcesDTO rcListResult = (ResultListResourcesDTO)this.handler.handleQuery(this.session, (AbstractQueryDTO)listQuery);
        Assertions.assertEquals((int)200, (int)rcListResult.statusCode);
        Assertions.assertTrue((boolean)rcListResult.resources.contains(RESOURCE), (String)"Resource is not registered");
        Instant queryTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        QueryGetDTO getQuery = new QueryGetDTO();
        getQuery.uri = new SensinactPath(provider2, SERVICE, RESOURCE);
        AbstractResultDTO result = this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        Assertions.assertEquals((int)204, (int)result.statusCode);
        Assertions.assertNotNull((Object)result.error, (String)"No warning message set");
        Assertions.assertFalse((boolean)result.error.isEmpty(), (String)"No warning message set");
        ResponseGetDTO response = this.utils.convert((TypedResponse)result, ResponseGetDTO.class);
        Assertions.assertNotNull((Object)response, (String)"No empty value response");
        Assertions.assertFalse((boolean)queryTime.isAfter(Instant.ofEpochMilli(response.timestamp)), (String)"Missing resource has a timestamp");
        Assertions.assertNull((Object)response.value, (String)"Got a value for a missing resource");
    }
}

