/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.test.integration;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.core.annotation.verb.ACT;
import org.eclipse.sensinact.core.annotation.verb.ActParam;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.northbound.query.api.AbstractQueryDTO;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.api.IQueryHandler;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;
import org.eclipse.sensinact.northbound.query.dto.query.QueryActDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryGetDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QuerySetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultActDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.query.test.integration.TestUtils;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class ResourceAccessTest {
    private static final UserInfo USER = UserInfo.ANONYMOUS;
    private static final String PROVIDER = "QueryHandlerAccessProvider";
    private static final String PROVIDER_TOPIC = "QueryHandlerAccessProvider/*";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final Integer VALUE = 42;
    private static final Integer VALUE_2 = 84;
    SensiNactSession session;
    @InjectService
    DataUpdate push;
    @InjectService
    IQueryHandler handler;
    BlockingQueue<ResourceDataNotification> queue;
    final TestUtils utils = new TestUtils();

    @BeforeEach
    void start(@InjectService SensiNactSessionManager sessionManager) throws Exception {
        this.session = sessionManager.getDefaultSession(USER);
    }

    @AfterEach
    void stop() {
        this.session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)this.session).removeListener(arg_0));
        this.session.expire();
    }

    @Test
    void resourceGet() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        Instant updateTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        QueryGetDTO getQuery = new QueryGetDTO();
        getQuery.uri = new SensinactPath(PROVIDER, SERVICE, RESOURCE);
        TypedResponse result = (TypedResponse)this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.GET_RESPONSE, PROVIDER, SERVICE, RESOURCE);
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)RESOURCE, (Object)response.name);
        Assertions.assertEquals((Object)VALUE, (Object)response.value);
        Assertions.assertEquals((Object)dto.type.getName(), (Object)response.type);
        Assertions.assertFalse((boolean)Instant.ofEpochMilli(response.timestamp).isBefore(updateTime), (String)"Timestamp wasn't updated");
    }

    @Test
    void resourceUpdate() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        Instant firstTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        QueryGetDTO getQuery = new QueryGetDTO();
        getQuery.uri = new SensinactPath(PROVIDER, SERVICE, RESOURCE);
        TypedResponse result = (TypedResponse)this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE, (Object)response.value);
        Assertions.assertFalse((boolean)Instant.ofEpochMilli(response.timestamp).isBefore(firstTime), (String)"Timestamp wasn't updated");
        dto.value = VALUE_2;
        Instant secondTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        result = (TypedResponse)this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE_2, (Object)response.value);
        Assertions.assertFalse((boolean)Instant.ofEpochMilli(response.timestamp).isBefore(secondTime), (String)"Timestamp wasn't updated");
    }

    @Test
    void resourceSet() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        Instant firstUpdateTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        QueryGetDTO getQuery = new QueryGetDTO();
        getQuery.uri = new SensinactPath(PROVIDER, SERVICE, RESOURCE);
        TypedResponse result = (TypedResponse)this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE, (Object)response.value);
        Instant firstTimestamp = Instant.ofEpochMilli(response.timestamp);
        Assertions.assertFalse((boolean)firstTimestamp.isBefore(firstUpdateTime), (String)"Timestamp wasn't updated");
        QuerySetDTO query = new QuerySetDTO();
        query.uri = new SensinactPath(PROVIDER, SERVICE, RESOURCE);
        query.valueType = Integer.class.getName();
        query.value = VALUE_2;
        this.queue = new ArrayBlockingQueue<ResourceDataNotification>(32);
        this.session.addListener(List.of(PROVIDER_TOPIC), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.queue.poll(500L, TimeUnit.MILLISECONDS));
        result = (TypedResponse)this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.SET_RESPONSE, PROVIDER, SERVICE, RESOURCE);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)RESOURCE, (Object)response.name);
        Assertions.assertEquals((Object)query.valueType, (Object)response.type);
        Assertions.assertEquals((Object)VALUE_2, (Object)response.value);
        dto.value = VALUE_2;
        this.utils.assertNotification(dto, this.queue.poll(1L, TimeUnit.SECONDS));
        result = (TypedResponse)this.handler.handleQuery(this.session, (AbstractQueryDTO)getQuery);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE_2, (Object)response.value);
        Assertions.assertTrue((boolean)firstTimestamp.isBefore(Instant.ofEpochMilli(response.timestamp)), (String)"Timestamp wasn't updated");
    }

    @Test
    void adminDefaultValues() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryGetDTO query = new QueryGetDTO();
        query.uri = new SensinactPath(PROVIDER, "admin", "friendlyName");
        TypedResponse result = (TypedResponse)this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.GET_RESPONSE, PROVIDER, "admin", "friendlyName");
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)String.class.getName(), (Object)response.type);
        Assertions.assertEquals((Object)PROVIDER, (Object)response.value);
        query.uri = new SensinactPath(PROVIDER, "admin", "location");
        result = (TypedResponse)this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultNoContent((AbstractResultDTO)result, EResultType.GET_RESPONSE, PROVIDER, "admin", "location");
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)GeoJsonObject.class.getName(), (Object)response.type);
        Assertions.assertNull((Object)response.value);
    }

    @Test
    void resourceAct(@InjectBundleContext BundleContext context) throws Exception {
        context.registerService(TestAction.class, (Object)new TestAction(), new Hashtable<String, Boolean>(Map.of("sensiNact.whiteboard.resource", true)));
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryActDTO actQuery = new QueryActDTO();
        actQuery.uri = new SensinactPath(PROVIDER, SERVICE, "action");
        actQuery.parameters = Map.of("input", 123);
        ResultActDTO response = (ResultActDTO)this.handler.handleQuery(this.session, (AbstractQueryDTO)actQuery);
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.statusCode);
        Assertions.assertNotNull((Object)response.response);
        Assertions.assertEquals((Object)246.0, (Object)response.response);
    }

    public static class TestAction {
        @ACT(model="QueryHandlerAccessProvider", service="service", resource="action")
        public Double toDoubleDouble(@ActParam(value="input") Long longValue) {
            return longValue.doubleValue() * 2.0;
        }
    }
}

