/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.integration;

import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.rest.integration.TestUtils;
import org.eclipse.sensinact.northbound.security.api.Authenticator;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.opentest4j.AssertionFailedError;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.service.ServiceAware;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class SecureAccessTest {
    private static final String PROVIDER = "RestSecureAccessProvider";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final Integer VALUE = 42;
    private static final String TOKEN = "Open Sesame";
    private static final String TOKEN_HEADER = "Bearer Open Sesame";
    private static final String USER = "Alice";
    private static final String CREDENTIAL = "Secret";
    private static final String BASIC_HEADER = "Basic QWxpY2U6U2VjcmV0";
    @InjectService
    DataUpdate push;
    @InjectBundleContext
    BundleContext ctx;
    final TestUtils utils = new TestUtils();

    @BeforeEach
    public void await(@InjectConfiguration(withConfig=@WithConfiguration(pid="sensinact.northbound.rest", location="?", properties={@Property(key="allow.anonymous", value={"false"}), @Property(key="fizz", value={"buzz"})})) Configuration cm, @InjectService(filter="(fizz=buzz)", cardinality=0) ServiceAware<Application> a) throws InterruptedException {
        a.waitForService(5000L);
        for (int i = 0; i < 10; ++i) {
            try {
                if (this.utils.queryStatus("/").statusCode() == 503) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(200L);
        }
        throw new AssertionFailedError("REST API did not appear");
    }

    @ParameterizedTest
    @ValueSource(strings={"Bearer Open Sesame", "Basic QWxpY2U6U2VjcmV0"})
    void resourceGet(String header) throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        Instant updateTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        String path = String.join((CharSequence)"/", "providers", PROVIDER, "services", SERVICE, "resources", RESOURCE, "GET");
        HttpResponse<?> response = this.utils.queryStatus(path);
        Assertions.assertEquals((int)Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), (int)response.statusCode());
        this.ctx.registerService(Authenticator.class, (Object)new TokenValidator(TOKEN), null);
        this.ctx.registerService(Authenticator.class, (Object)new BasicValidator(USER, CREDENTIAL), null);
        Thread.sleep(500L);
        response = this.utils.queryStatus(path);
        Assertions.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.statusCode());
        Assertions.assertEquals((Object)"Bearer realm=test, Basic realm=test2", (Object)response.headers().firstValue("WWW-Authenticate").get());
        TypedResponse result = this.utils.queryJson(path, TypedResponse.class, Map.of("Authorization", header));
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.GET_RESPONSE, PROVIDER, SERVICE, RESOURCE);
        ResponseGetDTO r = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)RESOURCE, (Object)r.name);
        Assertions.assertEquals((Object)VALUE, (Object)r.value);
        Assertions.assertEquals((Object)dto.type.getName(), (Object)r.type);
        Assertions.assertFalse((boolean)Instant.ofEpochMilli(r.timestamp).isBefore(updateTime), (String)"Timestamp wasn't updated");
    }

    private static class TokenValidator
    implements Authenticator {
        private final String token;

        public TokenValidator(String token) {
            this.token = token;
        }

        public UserInfo authenticate(String user, String credential) {
            return credential.equals(this.token) ? new TestUserInfo() : null;
        }

        public String getRealm() {
            return "test";
        }

        public Authenticator.Scheme getScheme() {
            return Authenticator.Scheme.TOKEN;
        }
    }

    private static class BasicValidator
    implements Authenticator {
        private final String user;
        private final String credential;

        public BasicValidator(String user, String credential) {
            this.user = user;
            this.credential = credential;
        }

        public UserInfo authenticate(String user, String credential) {
            return this.user.equals(user) && this.credential.equals(credential) ? new TestUserInfo() : null;
        }

        public String getRealm() {
            return "test2";
        }

        public Authenticator.Scheme getScheme() {
            return Authenticator.Scheme.USER_PASSWORD;
        }
    }

    private static class TestUserInfo
    implements UserInfo {
        private TestUserInfo() {
        }

        public String getUserId() {
            return "testUser";
        }

        public boolean isMemberOfGroup(String group) {
            return false;
        }

        public boolean isAnonymous() {
            return false;
        }

        public boolean isAuthenticated() {
            return true;
        }
    }
}

