/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.integration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.ws.rs.core.Application;
import java.net.http.HttpResponse;
import java.time.Instant;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.eclipse.sensinact.sensorthings.sensing.dto.Id;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Self;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.SensinactSensorthingsApplication;
import org.eclipse.sensinact.sensorthings.sensing.rest.integration.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.annotation.config.WithConfigurations;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.tracker.ServiceTracker;

@WithConfigurations(value={@WithConfiguration(pid="sensinact.sensorthings.northbound.rest", properties={@Property(key="test.class", source=Property.ValueSource.TestClass), @Property(key="sessionManager.target", value={"(test.class=%s)"}, templateArguments={@Property.TemplateArgument(source=Property.ValueSource.TestClass)})}), @WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"}), @Property(key="test.class", source=Property.ValueSource.TestClass)})})
public class AbstractIntegrationTest {
    protected static final TypeReference<ResultList<AnyIdDTO>> RESULT_ANY = new TypeReference<ResultList<AnyIdDTO>>(){};
    protected static final TypeReference<ResultList<Self>> RESULT_SELF = new TypeReference<ResultList<Self>>(){};
    private static final UserInfo USER = UserInfo.ANONYMOUS;
    @InjectService
    protected DataUpdate push;
    @InjectService
    protected GatewayThread thread;
    protected SensiNactSessionManager sessionManager;
    protected SensiNactSession session;
    protected final TestUtils utils = new TestUtils();

    @BeforeEach
    void start(@InjectBundleContext BundleContext bc, TestInfo info) throws Exception {
        Class<?> test = (Class<?>)info.getTestClass().get();
        while (test.isMemberClass()) {
            test = test.getEnclosingClass();
        }
        ServiceTracker tracker = new ServiceTracker(bc, bc.createFilter("(&(objectClass=jakarta.ws.rs.core.Application)(test.class=" + test.getName() + "))"), null);
        tracker.open();
        Application app = (Application)tracker.waitForService(5000L);
        Assertions.assertNotNull((Object)app);
        Assertions.assertInstanceOf(SensinactSensorthingsApplication.class, (Object)app);
        this.sessionManager = ((SensinactSensorthingsApplication)app).getSessionManager();
        this.session = this.sessionManager.getDefaultSession(USER);
        boolean ready = false;
        for (int i = 0; i < 10; ++i) {
            HttpResponse<String> result = this.utils.query("/Datastreams");
            if (result.statusCode() < 400) {
                ready = true;
                break;
            }
            System.out.println("Waiting for the SensorThings servlet to come up...");
            Thread.sleep(200L);
        }
        if (!ready) {
            Assertions.fail((String)"SensorThings servlet didn't come up");
        }
    }

    @AfterEach
    void stop() {
        this.session.expire();
        this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                twin.getProviders().forEach(SensinactProvider::delete);
                return null;
            }
        });
    }

    protected void createResource(String provider, String service, String resource, Object value) {
        this.createResource(provider, service, resource, value, null);
    }

    protected void createResource(String provider, String service, String resource, Object value, Instant instant) {
        GenericDto dto = new GenericDto();
        dto.provider = provider;
        dto.service = service;
        dto.resource = resource;
        dto.type = value.getClass();
        dto.value = value;
        dto.timestamp = instant;
        try {
            this.push.pushUpdate((Object)dto).getValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class AnyIdDTO
    extends Id {
        AnyIdDTO() {
        }
    }
}

