/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.integration;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.RootResponse;
import org.eclipse.sensinact.sensorthings.sensing.dto.Self;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.integration.AbstractIntegrationTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class FiltersTest
extends AbstractIntegrationTest {
    final Random random = new Random();

    @Test
    void testCountFilter() throws IOException, InterruptedException {
        int nbProviders = 4;
        for (int i = 0; i < nbProviders; ++i) {
            this.createResource("countTester_" + (i + 1), "sensor", "rc", this.random.nextInt());
            this.createResource("countTester_" + (i + 1), "admin", "location", new Point());
        }
        RootResponse rootResponse = this.utils.queryJson("/", RootResponse.class);
        for (RootResponse.NameUrl url : rootResponse.value) {
            ResultList resultList = (ResultList)this.utils.queryJson(url.url, RESULT_ANY);
            Assertions.assertNull((Object)resultList.count);
            Assertions.assertNotNull((Object)resultList.value);
            resultList = (ResultList)this.utils.queryJson(url.url + "?$count=false", RESULT_ANY);
            Assertions.assertNull((Object)resultList.count);
            Assertions.assertNotNull((Object)resultList.value);
            resultList = (ResultList)this.utils.queryJson(url.url + "?$count=true", RESULT_ANY);
            Assertions.assertTrue((resultList.value.size() >= nbProviders ? 1 : 0) != 0, (String)("Expected " + resultList.value.size() + " >= " + nbProviders + " at " + url.url));
            Assertions.assertEquals((int)resultList.value.size(), (Integer)resultList.count);
            this.utils.assertURLStatus(url.url + "?$count=yes", 400);
            this.utils.assertURLStatus(url.url + "?$count=no", 400);
            this.utils.assertURLStatus(url.url + "?$count=1", 400);
            this.utils.assertURLStatus(url.url + "?$count=0", 400);
            this.utils.assertURLStatus(url.url + "?$count=", 400);
        }
    }

    private List<String> extractProviderIds(ResultList<AbstractIntegrationTest.AnyIdDTO> resultList, Predicate<String> filter) {
        return resultList.value.stream().map(item -> {
            String rawId = (String)item.id;
            if (rawId == null) {
                return null;
            }
            return rawId.split("~")[0];
        }).distinct().filter(filter).collect(Collectors.toList());
    }

    @Test
    void testOrderBy() throws IOException, InterruptedException {
        String prefix = "orderTester_";
        List sortedProviderIds = IntStream.rangeClosed(0, 9).boxed().map(id -> "orderTester_" + id).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        int nbProviders = sortedProviderIds.size();
        ArrayList reversedProviderIds = new ArrayList(sortedProviderIds);
        Collections.reverse(reversedProviderIds);
        sortedProviderIds.stream().filter(id -> id.startsWith("orderTester_")).forEach(id -> {
            this.createResource((String)id, "svcA", "rcA", id);
            this.createResource((String)id, "svcB", "rcA", id + "256");
            this.createResource((String)id, "svcA", "rcB", id);
            this.createResource((String)id, "svcB", "rcB", id + "256");
            this.createResource((String)id, "admin", "location", new Point());
        });
        Predicate<String> filter = sortedProviderIds::contains;
        RootResponse rootResponse = this.utils.queryJson("/", RootResponse.class);
        for (RootResponse.NameUrl url : rootResponse.value) {
            ResultList resultList = (ResultList)this.utils.queryJson(url.url, RESULT_ANY);
            Assertions.assertNull((Object)resultList.count);
            Assertions.assertEquals(sortedProviderIds, this.extractProviderIds((ResultList<AbstractIntegrationTest.AnyIdDTO>)resultList, filter));
            resultList = (ResultList)this.utils.queryJson(url.url + "?$orderby=id", RESULT_ANY);
            Assertions.assertNull((Object)resultList.count);
            Assertions.assertEquals(sortedProviderIds, this.extractProviderIds((ResultList<AbstractIntegrationTest.AnyIdDTO>)resultList, filter));
            resultList = (ResultList)this.utils.queryJson(url.url + "?$orderby=id%20asc", RESULT_ANY);
            Assertions.assertNull((Object)resultList.count);
            Assertions.assertEquals(sortedProviderIds, this.extractProviderIds((ResultList<AbstractIntegrationTest.AnyIdDTO>)resultList, filter));
            resultList = (ResultList)this.utils.queryJson(url.url + "?$orderby=id&$count=true", RESULT_ANY);
            Assertions.assertTrue((resultList.count >= nbProviders ? 1 : 0) != 0);
            Assertions.assertEquals(sortedProviderIds, this.extractProviderIds((ResultList<AbstractIntegrationTest.AnyIdDTO>)resultList, filter));
            resultList = (ResultList)this.utils.queryJson(url.url + "?$orderby=id%20desc", RESULT_ANY);
            Assertions.assertNull((Object)resultList.count);
            Assertions.assertEquals(reversedProviderIds, this.extractProviderIds((ResultList<AbstractIntegrationTest.AnyIdDTO>)resultList, filter));
            resultList = (ResultList)this.utils.queryJson(url.url + "?$orderby=id%20%20%20desc", RESULT_ANY);
            Assertions.assertNull((Object)resultList.count);
            Assertions.assertEquals(reversedProviderIds, this.extractProviderIds((ResultList<AbstractIntegrationTest.AnyIdDTO>)resultList, filter));
            resultList = (ResultList)this.utils.queryJson(url.url + "?$orderby=id%20desc&$count=true", RESULT_ANY);
            Assertions.assertTrue((resultList.count >= nbProviders ? 1 : 0) != 0);
            Assertions.assertEquals(reversedProviderIds, this.extractProviderIds((ResultList<AbstractIntegrationTest.AnyIdDTO>)resultList, filter));
        }
    }

    @Test
    void testRef() throws IOException, InterruptedException {
        String provider = "refTester";
        String svc = "sensor";
        String rc = "rc";
        this.createResource("refTester", "sensor", "rc", 42);
        ResultList resultList = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams/$ref", "refTester"), RESULT_SELF);
        Assertions.assertNull((Object)resultList.count);
        List references = resultList.value.stream().filter(s2 -> s2.selfLink.endsWith(String.format("Datastreams(%s)", String.join((CharSequence)"~", "refTester", "sensor", "rc")))).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)references.size());
        resultList = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams/$ref?$count=true", "refTester"), RESULT_SELF);
        Assertions.assertEquals((int)resultList.value.size(), (Integer)resultList.count);
        references = resultList.value.stream().filter(s2 -> s2.selfLink.endsWith(String.format("Datastreams(%s)", String.join((CharSequence)"~", "refTester", "sensor", "rc")))).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)references.size());
    }

    @Test
    void testProp() throws IOException, InterruptedException {
        Instant creationTime = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        String provider = "propTester";
        String svc = "sensor";
        String rc = "rc";
        int value = this.random.nextInt();
        this.createResource("propTester", "sensor", "rc", value, creationTime);
        ResultList observations = (ResultList)this.utils.queryJson(String.format("/FeaturesOfInterest(%s)/Observations/$ref", "propTester"), RESULT_SELF);
        String baseUrl = observations.value.stream().filter((Predicate<Self>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testProp$6(org.eclipse.sensinact.sensorthings.sensing.dto.Self ), (Lorg/eclipse/sensinact/sensorthings/sensing/dto/Self;)Z)()).findFirst().get().selfLink;
        String property = "resultTime";
        Map rawResult = this.utils.queryJson(baseUrl + "/" + property, Map.class);
        Assertions.assertEquals(Set.of(property), rawResult.keySet());
        Assertions.assertEquals((Object)creationTime.toString(), rawResult.get(property));
        property = "result";
        rawResult = this.utils.queryJson(baseUrl + "/" + property, Map.class);
        Assertions.assertEquals(Set.of(property), rawResult.keySet());
        Assertions.assertEquals((Object)value, rawResult.get(property));
    }

    @Test
    void testSelect() throws IOException, InterruptedException {
        String provider = "selectTester";
        String svc = "sensor";
        String rc = "rc";
        this.createResource("selectTester", "sensor", "rc", 42);
        Set<String> selectedFields = Set.of("result", "resultTime");
        Map rawResultList = this.utils.queryJson("/Observations/?$select=" + String.join((CharSequence)",", selectedFields), Map.class);
        List items = (List)rawResultList.get("value");
        Assertions.assertFalse((boolean)items.isEmpty());
        for (Object rawItem : items) {
            Map item = (Map)this.utils.getMapper().convertValue(rawItem, Map.class);
            Assertions.assertEquals(selectedFields, item.keySet());
        }
    }

    @Test
    void testSkipTop() throws IOException, InterruptedException {
        String provider = "skipTopFilter";
        String svc = "sensor";
        String rcPrefix = "rc";
        int nbRc = 5;
        for (int i = 0; i < 5; ++i) {
            this.createResource("skipTopFilter", "sensor", "rc" + i, i);
        }
        ResultList allStreams = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams?$count=true", "skipTopFilter"), RESULT_ANY);
        int nbIds = allStreams.count;
        List allIds = allStreams.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
        Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0);
        Assertions.assertEquals((int)allIds.size(), (int)nbIds);
        int topVal = 2;
        ResultList subStreams = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams?$top=%d", "skipTopFilter", topVal), RESULT_ANY);
        List ids = subStreams.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
        Assertions.assertNull((Object)subStreams.count);
        Assertions.assertEquals((int)topVal, (int)ids.size());
        Assertions.assertEquals(allIds.subList(0, topVal), ids);
        subStreams = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams?$top=%d&$count=true", "skipTopFilter", topVal), RESULT_ANY);
        Assertions.assertEquals(ids, subStreams.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList()));
        Assertions.assertEquals((int)nbIds, (Integer)subStreams.count);
        int skipVal = 2;
        subStreams = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams?$skip=%d", "skipTopFilter", skipVal), RESULT_ANY);
        ids = subStreams.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
        Assertions.assertNull((Object)subStreams.count);
        Assertions.assertEquals((int)(nbIds - skipVal), (int)ids.size());
        Assertions.assertEquals(allIds.subList(skipVal, allIds.size()), ids);
        subStreams = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams?$skip=%d&$count=true", "skipTopFilter", skipVal), RESULT_ANY);
        Assertions.assertEquals(ids, subStreams.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList()));
        Assertions.assertEquals((int)nbIds, (Integer)subStreams.count);
        subStreams = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams?$top=%d&$skip=%d", "skipTopFilter", topVal, skipVal), RESULT_ANY);
        ids = subStreams.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
        Assertions.assertNull((Object)subStreams.count);
        Assertions.assertEquals((int)topVal, (int)ids.size());
        Assertions.assertEquals(allIds.subList(skipVal, skipVal + topVal), ids);
        subStreams = (ResultList)this.utils.queryJson(String.format("/Things(%s)/Datastreams?$top=%d&$skip=%d&$count=true", "skipTopFilter", topVal, skipVal), RESULT_ANY);
        Assertions.assertEquals(ids, subStreams.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList()));
        Assertions.assertEquals((int)nbIds, (Integer)subStreams.count);
    }

    private static /* synthetic */ boolean lambda$testProp$6(Self s2) {
        return s2.selfLink.contains(String.join((CharSequence)"~", "propTester", "sensor", "rc"));
    }

    @Nested
    class ExpandFilterTest {
        ExpandFilterTest() {
        }

        @Test
        void testExpand() throws IOException, InterruptedException {
            String provider = "expandTester";
            String svc = "sensor";
            String rc = "rc";
            FiltersTest.this.createResource("expandTester", "sensor", "rc_1", 42);
            FiltersTest.this.createResource("expandTester", "sensor", "rc_2", 24);
            Set<String> expandedFields = Set.of("Datastreams/Observations", "Locations");
            Map rawResultList = FiltersTest.this.utils.queryJson("/Things/?$expand=" + String.join((CharSequence)",", expandedFields), Map.class);
            List items = (List)rawResultList.get("value");
            Assertions.assertFalse((boolean)items.isEmpty());
            Assertions.assertEquals((int)1, (int)items.size());
            Map rawThing = items.stream().map(Map.class::cast).filter(m4 -> !"sensiNact".equals(m4.get("name"))).findFirst().get();
            List rawDatastreamsList = (List)rawThing.get("Datastreams");
            Assertions.assertNotNull((Object)rawDatastreamsList);
            Assertions.assertEquals((int)6, (int)rawDatastreamsList.size());
            Map rawDatastream = rawDatastreamsList.stream().map(Map.class::cast).filter(m4 -> "expandTester~sensor~rc_1".equals(m4.get("@iot.id"))).findFirst().get();
            List rawObservationsList = (List)rawDatastream.get("Observations");
            Assertions.assertNotNull((Object)rawObservationsList);
            Assertions.assertEquals((int)1, (int)rawObservationsList.size());
            Map rawObservation = (Map)rawObservationsList.get(0);
            Assertions.assertNotNull((Object)rawObservation);
            Assertions.assertEquals((Object)42, rawObservation.get("result"));
            rawDatastream = rawDatastreamsList.stream().map(Map.class::cast).filter(m4 -> "expandTester~sensor~rc_2".equals(m4.get("@iot.id"))).findFirst().get();
            rawObservationsList = (List)rawDatastream.get("Observations");
            Assertions.assertNotNull((Object)rawObservationsList);
            Assertions.assertEquals((int)1, (int)rawObservationsList.size());
            rawObservation = (Map)rawObservationsList.get(0);
            Assertions.assertNotNull((Object)rawObservation);
            Assertions.assertEquals((Object)24, rawObservation.get("result"));
        }

        @Test
        void testExpandSingle() throws IOException, InterruptedException {
            String provider = "expandTester";
            String svc = "sensor";
            String rc = "rc";
            FiltersTest.this.createResource("expandTester", "sensor", "rc_1", 42);
            Set<String> expandedFields = Set.of("Thing", "Sensor");
            Map rawDatastream = FiltersTest.this.utils.queryJson("/Datastreams(expandTester~sensor~rc_1)/?$expand=" + String.join((CharSequence)",", expandedFields), Map.class);
            Map rawThing = (Map)rawDatastream.get("Thing");
            Assertions.assertNotNull((Object)rawThing);
            Assertions.assertEquals((Object)"expandTester", rawThing.get("@iot.id"));
            Map rawSensor = (Map)rawDatastream.get("Sensor");
            Assertions.assertNotNull((Object)rawSensor);
            Assertions.assertEquals((Object)"expandTester~sensor~rc_1", rawSensor.get("@iot.id"));
        }
    }

    @Nested
    class FilterFilterTest {
        final List<String> above40 = new ArrayList<String>();
        final List<String> below40 = new ArrayList<String>();
        final int nbRc = 5;
        String provider1 = null;
        String provider2 = null;
        final String svc = "sensor";
        final String rcPrefix = "rc";

        FilterFilterTest() {
        }

        @BeforeEach
        void setup(TestInfo testInfo) {
            String testMethodName = ((Method)testInfo.getTestMethod().get()).getName();
            this.provider1 = testMethodName + "_1";
            this.provider2 = testMethodName + "_2";
            for (int i = 0; i < 5; ++i) {
                String rcName = "rc" + i;
                FiltersTest.this.createResource(this.provider1, "sensor", rcName, i);
                FiltersTest.this.createResource(this.provider2, "sensor", rcName, 40 + i);
                this.below40.add(String.join((CharSequence)"~", this.provider1, "sensor", rcName));
                this.above40.add(String.join((CharSequence)"~", this.provider2, "sensor", rcName));
            }
            FiltersTest.this.createResource(this.provider1, "admin", "location", new Point());
            FiltersTest.this.createResource(this.provider2, "admin", "location", new Point());
        }

        @AfterEach
        void cleanup() {
            this.provider1 = null;
            this.provider2 = null;
            this.above40.clear();
            this.below40.clear();
        }

        @Test
        void testFilterThings() throws Exception {
            TypeReference<ResultList<Thing>> RESULT_THINGS = new TypeReference<ResultList<Thing>>(){};
            ResultList<Thing> things = FiltersTest.this.utils.queryJson(String.format("/Things?$filter=%s", URLEncoder.encode("Datastreams/Observations/result lt 30", StandardCharsets.UTF_8)), RESULT_THINGS);
            List allIds = things.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 1 ? 1 : 0) != 0, (String)"Not enough things returned");
            Assertions.assertTrue((boolean)allIds.contains(this.provider1), (String)(this.provider1 + " not in result"));
            Assertions.assertFalse((boolean)allIds.contains(this.provider2), (String)(this.provider2 + " in result"));
            things = FiltersTest.this.utils.queryJson(String.format("/Things?$filter=%s", URLEncoder.encode("Datastreams/Observations/FeatureOfInterest/id eq '" + this.provider2 + "'", StandardCharsets.UTF_8)), RESULT_THINGS);
            allIds = things.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 1 ? 1 : 0) != 0, (String)"Not enough things returned");
            Assertions.assertTrue((boolean)allIds.contains(this.provider2), (String)(this.provider2 + " not in result"));
            Assertions.assertFalse((boolean)allIds.contains(this.provider1), (String)(this.provider1 + " in result"));
            FiltersTest.this.createResource("filterFOI_1", "some-service", "some-resource", 42, ZonedDateTime.of(2010, 6, 15, 21, 42, 0, 0, ZoneOffset.UTC).toInstant());
            things = FiltersTest.this.utils.queryJson(String.format("/Things?$filter=%s", URLEncoder.encode("Datastreams/Observations/FeatureOfInterest/id eq 'filterFOI_1' and Datastreams/Observations/resultTime ge 2010-06-01T00:00:00Z and Datastreams/Observations/resultTime le 2010-07-01T00:00:00Z", StandardCharsets.UTF_8)), RESULT_THINGS);
            Assertions.assertEquals((int)1, (int)things.value.size(), (String)"Not enough things returned");
            Assertions.assertEquals((Object)"filterFOI_1", (Object)((Thing)things.value.get((int)0)).id);
        }

        @Test
        void testFilterLocations() throws Exception {
            TypeReference<ResultList<Location>> RESULT_LOCATIONS = new TypeReference<ResultList<Location>>(){};
            ResultList<Location> items = FiltersTest.this.utils.queryJson(String.format("/Locations?$filter=%s", URLEncoder.encode("Things/id eq '" + this.provider2 + "'", StandardCharsets.UTF_8)), RESULT_LOCATIONS);
            List allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 1 ? 1 : 0) != 0, (String)"Not enough locations returned");
            for (String id : allIds) {
                Assertions.assertTrue((boolean)id.startsWith(this.provider2 + "~"), (String)("Found: " + id));
            }
        }

        @Test
        void testFilterHistoricalLocations() throws Exception {
            TypeReference<ResultList<HistoricalLocation>> RESULT_HISTORICAL_LOCATIONS = new TypeReference<ResultList<HistoricalLocation>>(){};
            ResultList<HistoricalLocation> items = FiltersTest.this.utils.queryJson(String.format("/HistoricalLocations?$filter=%s", URLEncoder.encode("Things/id eq '" + this.provider2 + "'", StandardCharsets.UTF_8)), RESULT_HISTORICAL_LOCATIONS);
            List allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 1 ? 1 : 0) != 0, (String)"Not enough historical locations returned");
            for (String id : allIds) {
                Assertions.assertTrue((boolean)id.startsWith(this.provider2 + "~"), (String)("Found: " + id));
            }
        }

        @Test
        void testFilterDatastreams() throws Exception {
            TypeReference<ResultList<Datastream>> RESULT_DATASTREAMS = new TypeReference<ResultList<Datastream>>(){};
            ResultList<Datastream> items = FiltersTest.this.utils.queryJson(String.format("/Datastreams?$filter=%s", URLEncoder.encode("Observations/result ge 40", StandardCharsets.UTF_8)), RESULT_DATASTREAMS);
            List allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0, (String)"Not enough datastreams returned");
            for (String below : this.below40) {
                Assertions.assertFalse((boolean)allIds.contains(below), (String)(below + " in result"));
            }
            for (String above : this.above40) {
                Assertions.assertTrue((boolean)allIds.contains(above), (String)(above + " not in result"));
            }
            items = FiltersTest.this.utils.queryJson(String.format("/Datastreams?$filter=%s", URLEncoder.encode("Observations/FeatureOfInterest/id eq '" + this.provider1 + "'", StandardCharsets.UTF_8)), RESULT_DATASTREAMS);
            allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0, (String)"Not enough datastreams returned");
            for (String id : allIds) {
                Assertions.assertTrue((boolean)id.startsWith(this.provider1 + "~"), (String)("Found: " + id));
            }
            String expectedId = String.join((CharSequence)"~", this.provider1, "sensor", "rc2");
            items = FiltersTest.this.utils.queryJson(String.format("/Datastreams?$filter=%s", URLEncoder.encode("id eq '" + expectedId + "'", StandardCharsets.UTF_8)), RESULT_DATASTREAMS);
            allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 1 ? 1 : 0) != 0, (String)"Not enough datastreams returned");
            for (String id : allIds) {
                Assertions.assertEquals((Object)expectedId, (Object)id, (String)("Found: " + id));
            }
        }

        @Test
        void testFilterSensors() throws Exception {
            TypeReference<ResultList<Sensor>> RESULT_SENSORS = new TypeReference<ResultList<Sensor>>(){};
            ResultList<Sensor> items = FiltersTest.this.utils.queryJson(String.format("/Sensors?$filter=%s", URLEncoder.encode("Datastreams/Observations/result ge 40", StandardCharsets.UTF_8)), RESULT_SENSORS);
            List allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0, (String)"Not enough sensors returned");
            for (String below : this.below40) {
                Assertions.assertFalse((boolean)allIds.contains(below), (String)(below + " in result"));
            }
            for (String above : this.above40) {
                Assertions.assertTrue((boolean)allIds.contains(above), (String)(above + " not in result"));
            }
            items = FiltersTest.this.utils.queryJson(String.format("/Sensors?$filter=%s", URLEncoder.encode("Datastreams/Observations/FeatureOfInterest/id eq '" + this.provider1 + "'", StandardCharsets.UTF_8)), RESULT_SENSORS);
            allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0, (String)"Not enough sensors returned");
            for (String id : allIds) {
                Assertions.assertTrue((boolean)id.startsWith(this.provider1 + "~"), (String)("Found: " + id));
            }
            String expectedId = String.join((CharSequence)"~", this.provider1, "sensor", "rc2");
            items = FiltersTest.this.utils.queryJson(String.format("/Sensors?$filter=%s", URLEncoder.encode("id eq '" + expectedId + "'", StandardCharsets.UTF_8)), RESULT_SENSORS);
            allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 1 ? 1 : 0) != 0, (String)"Not enough sensors returned");
            for (String id : allIds) {
                Assertions.assertEquals((Object)expectedId, (Object)id, (String)("Found: " + id));
            }
        }

        @Test
        void testFilterObservedProperties() throws Exception {
            TypeReference<ResultList<ObservedProperty>> RESULT_OBS_PROPS = new TypeReference<ResultList<ObservedProperty>>(){};
            ResultList<ObservedProperty> items = FiltersTest.this.utils.queryJson(String.format("/ObservedProperties?$filter=%s", URLEncoder.encode("Datastreams/Observations/result ge 40", StandardCharsets.UTF_8)), RESULT_OBS_PROPS);
            List allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0, (String)"Not enough ObservedProperties returned");
            for (String below : this.below40) {
                Assertions.assertFalse((boolean)allIds.contains(below), (String)(below + " in result"));
            }
            for (String above : this.above40) {
                Assertions.assertTrue((boolean)allIds.contains(above), (String)(above + " not in result"));
            }
            items = FiltersTest.this.utils.queryJson(String.format("/ObservedProperties?$filter=%s", URLEncoder.encode("Datastreams/Observations/FeatureOfInterest/id eq '" + this.provider1 + "'", StandardCharsets.UTF_8)), RESULT_OBS_PROPS);
            allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0, (String)"Not enough ObservedProperties returned");
            for (String id : allIds) {
                Assertions.assertTrue((boolean)id.startsWith(this.provider1 + "~"), (String)("Found: " + id));
            }
            String expectedId = String.join((CharSequence)"~", this.provider1, "sensor", "rc2");
            items = FiltersTest.this.utils.queryJson(String.format("/ObservedProperties?$filter=%s", URLEncoder.encode("id eq '" + expectedId + "'", StandardCharsets.UTF_8)), RESULT_OBS_PROPS);
            allIds = items.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 1 ? 1 : 0) != 0, (String)"Not enough ObservedProperties returned");
            for (String id : allIds) {
                Assertions.assertEquals((Object)expectedId, (Object)id, (String)("Found: " + id));
            }
        }

        @Test
        void testFilterObservations() throws Exception {
            TypeReference<ResultList<Observation>> RESULT_OBSERVATIONS = new TypeReference<ResultList<Observation>>(){};
            ResultList<Observation> obs = FiltersTest.this.utils.queryJson(String.format("/Observations?$filter=%s", URLEncoder.encode("result ge 40", StandardCharsets.UTF_8)), RESULT_OBSERVATIONS);
            List allIds = obs.value.stream().map(s2 -> (String)s2.id).map(s2 -> s2.substring(0, s2.lastIndexOf(126))).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0, (String)"Not enough observations returned");
            for (String below : this.below40) {
                Assertions.assertFalse((boolean)allIds.contains(below), (String)(below + " in result"));
            }
            for (String above : this.above40) {
                Assertions.assertTrue((boolean)allIds.contains(above), (String)(above + " not in result"));
            }
            obs = FiltersTest.this.utils.queryJson(String.format("/Observations?$filter=%s", URLEncoder.encode("FeatureOfInterest/id eq '" + this.provider1 + "'", StandardCharsets.UTF_8)), RESULT_OBSERVATIONS);
            allIds = obs.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 5 ? 1 : 0) != 0, (String)"Not enough observations returned");
            for (String id : allIds) {
                Assertions.assertTrue((boolean)id.startsWith(this.provider1 + "~"), (String)("Found: " + id));
            }
            String expectedId = String.join((CharSequence)"~", this.provider1, "sensor", "rc2");
            obs = FiltersTest.this.utils.queryJson(String.format("/Observations?$filter=%s", URLEncoder.encode("Datastream/id eq '" + expectedId + "'", StandardCharsets.UTF_8)), RESULT_OBSERVATIONS);
            allIds = obs.value.stream().map(s2 -> (String)s2.id).collect(Collectors.toList());
            Assertions.assertTrue((allIds.size() >= 1 ? 1 : 0) != 0, (String)"Not enough observations returned");
            for (String id : allIds) {
                Assertions.assertTrue((boolean)id.startsWith(expectedId + "~"), (String)("Found: " + id));
            }
        }
    }
}

