/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.integration;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Id;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.RootResponse;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.integration.AbstractIntegrationTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LinksTest
extends AbstractIntegrationTest {
    private static final TypeReference<ResultList<Datastream>> RESULT_DATASTREAMS = new TypeReference<ResultList<Datastream>>(){};
    private static final TypeReference<ResultList<HistoricalLocation>> RESULT_HISTORICAL_LOCATIONS = new TypeReference<ResultList<HistoricalLocation>>(){};
    private static final TypeReference<ResultList<Location>> RESULT_LOCATIONS = new TypeReference<ResultList<Location>>(){};
    private static final TypeReference<ResultList<Observation>> RESULT_OBSERVATIONS = new TypeReference<ResultList<Observation>>(){};
    private static final TypeReference<ResultList<Sensor>> RESULT_SENSORS = new TypeReference<ResultList<Sensor>>(){};
    private static final TypeReference<ResultList<Thing>> RESULT_THINGS = new TypeReference<ResultList<Thing>>(){};
    private static final String PROVIDER = "linkTester";
    private final Map<String, Class<? extends Id>> dtoClassCache = new HashMap<String, Class<? extends Id>>();
    private final Map<Class<?>, List<String>> classFields = new HashMap();

    @AfterEach
    void clear() {
        this.dtoClassCache.clear();
        this.classFields.clear();
    }

    private <S extends Id> void checkMirror(String mirrorBaseUrl, S srcObject, Class<S> srcType) throws IOException, InterruptedException {
        String mirrorUrl = String.format("%s/%s", mirrorBaseUrl, srcType.getSimpleName());
        try {
            Id mirrorAccess = (Id)this.utils.queryJson(mirrorUrl, srcType);
            this.utils.assertDtoEquals(srcObject, mirrorAccess, srcType);
            return;
        }
        catch (IOException mirrorAccess) {
            mirrorUrl = String.format("%s/%s", mirrorBaseUrl, srcType.getSimpleName() + "s");
            Map base = this.utils.queryJson(mirrorUrl, Map.class);
            List mirrorAccess2 = (List)this.utils.getMapper().convertValue(base.get("value"), List.class);
            boolean found = false;
            for (Object rawItem : mirrorAccess2) {
                Id item = (Id)this.utils.getMapper().convertValue(rawItem, srcType);
                if (!srcObject.id.equals(item.id)) continue;
                found = true;
                this.utils.assertDtoEquals(srcObject, item, srcType);
                break;
            }
            Assertions.assertTrue((boolean)found, (String)"Source object not found in mirror list");
            return;
        }
    }

    private String toPluralLink(String kindOfLink) {
        switch (kindOfLink) {
            case "FeatureOfInterest": {
                return "FeaturesOfInterest";
            }
        }
        return kindOfLink.replaceFirst("y$", "ie") + "s";
    }

    private <T extends Id> Class<T> getDTOType(String simpleName) {
        Class clazz = this.dtoClassCache.computeIfAbsent(simpleName, k -> {
            try {
                return Class.forName(Id.class.getPackageName() + "." + simpleName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
        if (clazz == null) {
            Assertions.fail((String)("Class not found " + simpleName));
        }
        return clazz;
    }

    private Set<Object> listIdsFromURL(String url) throws IOException, InterruptedException {
        return ((ResultList)this.utils.queryJson((String)url, LinksTest.RESULT_ANY)).value.stream().map(o -> o.id).collect(Collectors.toSet());
    }

    private <S extends Id, T extends Id> void checkSubLinks(S srcObject, String listUrl, TypeReference<ResultList<T>> resultListType, Class<T> resultType) throws IOException, InterruptedException {
        ResultList<T> results = this.utils.queryJson(listUrl, resultListType);
        Assertions.assertNotNull(results);
        Assertions.assertFalse((boolean)results.value.isEmpty(), (String)("No " + resultType.getSimpleName() + " found for " + srcObject.id + " on " + listUrl));
        Class<?> srcType = srcObject.getClass();
        ObjectMapper mapper = this.utils.getMapper();
        List fields = List.of();
        if (!results.value.isEmpty()) {
            Class<?> itemType = ((Id)results.value.get(0)).getClass();
            fields = this.classFields.computeIfAbsent(itemType, k -> Arrays.stream(itemType.getFields()).filter(f -> {
                String fieldName = f.getName();
                return fieldName.endsWith("Link") && !"selfLink".equals(fieldName);
            }).map(f -> f.getName()).collect(Collectors.toList()));
        }
        for (Id item : results.value) {
            String directAccessItemUrl = String.format("%s(%s)", listUrl, item.id);
            Id directAccessItem = (Id)this.utils.queryJson(directAccessItemUrl, resultType);
            this.utils.assertDtoEquals(item, directAccessItem, resultType);
            this.checkMirror(String.format("%s(%s)", listUrl, item.id), srcObject, srcType);
            for (String fieldName : fields) {
                Object kindOfLink = fieldName.substring(0, fieldName.length() - "Link".length());
                if (((String)(kindOfLink = Character.toUpperCase(((String)kindOfLink).charAt(0)) + ((String)kindOfLink).substring(1))).endsWith("s") || ((String)kindOfLink).startsWith("Features")) {
                    Set<Object> linkedItemsIds = this.listIdsFromURL(String.format("%s/%s", directAccessItemUrl, kindOfLink));
                    Set<Object> allItemsIds = this.listIdsFromURL((String)kindOfLink);
                    Assertions.assertTrue((boolean)allItemsIds.containsAll(linkedItemsIds), (String)(linkedItemsIds + " not a subset of " + allItemsIds + " (src=" + srcObject.id + ", listUrl=" + listUrl + ", kindOfLink=" + (String)kindOfLink + ")"));
                    continue;
                }
                Class<T> linkType = this.getDTOType((String)kindOfLink);
                Id linkedDto = (Id)mapper.convertValue((Object)this.utils.queryJson(String.format("%s/%s", directAccessItemUrl, kindOfLink), Map.class), linkType);
                Id directDto = (Id)mapper.convertValue((Object)this.utils.queryJson(String.format("%s(%s)", this.toPluralLink((String)kindOfLink), linkedDto.id), Map.class), linkType);
                this.utils.assertDtoEquals(directDto, linkedDto, linkType);
            }
        }
    }

    @Test
    void testLinksFromRoot() throws IOException, InterruptedException {
        RootResponse root = this.utils.queryJson("/", RootResponse.class);
        Assertions.assertNotNull((Object)root);
        for (RootResponse.NameUrl nameUrl : root.value) {
            Assertions.assertNotNull((Object)nameUrl);
            Assertions.assertNotNull((Object)nameUrl.name, (String)"Null link name");
            Assertions.assertFalse((boolean)nameUrl.name.isEmpty(), (String)"Empty name");
            Assertions.assertNotNull((Object)nameUrl.url, (String)"Null link URL");
            Assertions.assertFalse((boolean)nameUrl.url.isEmpty(), (String)"Empty URL");
            this.utils.assertURLStatus(nameUrl.url, 200);
        }
    }

    @Test
    void testLinksFromThings() throws IOException, InterruptedException {
        this.createResource(PROVIDER, "sensor", "data", 42);
        this.createResource(PROVIDER, "admin", "location", new Point());
        ResultList<Thing> things = this.utils.queryJson("/Things", RESULT_THINGS);
        Assertions.assertNotNull(things);
        Assertions.assertFalse((boolean)things.value.isEmpty(), (String)"No thing found");
        for (Thing thing : things.value) {
            Set<Object> dsThingHistoricalLocationIDs;
            Set<Object> dsThingLocationIDs;
            Set<Object> dsThingStreamIDs;
            Assertions.assertNotNull((Object)thing);
            Assertions.assertNotNull((Object)thing.id);
            Assertions.assertNotNull((Object)thing.name);
            this.utils.assertURLStatus(thing.selfLink);
            this.utils.assertDtoEquals(thing, this.utils.queryJson(thing.selfLink, Thing.class), Thing.class);
            this.checkSubLinks(thing, thing.datastreamsLink, RESULT_DATASTREAMS, Datastream.class);
            this.checkSubLinks(thing, thing.historicalLocationsLink, RESULT_HISTORICAL_LOCATIONS, HistoricalLocation.class);
            this.checkSubLinks(thing, thing.locationsLink, RESULT_LOCATIONS, Location.class);
            Set<Object> datastreamIDs = this.listIdsFromURL(thing.datastreamsLink);
            Set<Object> locationIDs = this.listIdsFromURL(thing.locationsLink);
            Set<Object> historicalLocationsIDs = this.listIdsFromURL(thing.historicalLocationsLink);
            for (Object dsId : datastreamIDs) {
                dsThingStreamIDs = this.listIdsFromURL(String.format("/Datastreams(%s)/Thing/Datastreams", dsId));
                Assertions.assertEquals(datastreamIDs, dsThingStreamIDs);
                dsThingLocationIDs = this.listIdsFromURL(String.format("/Datastreams(%s)/Thing/Locations", dsId));
                Assertions.assertEquals(locationIDs, dsThingLocationIDs);
                dsThingHistoricalLocationIDs = this.listIdsFromURL(String.format("/Datastreams(%s)/Thing/HistoricalLocations", dsId));
                Assertions.assertEquals(historicalLocationsIDs, dsThingHistoricalLocationIDs);
            }
            for (Object locId : locationIDs) {
                dsThingStreamIDs = this.listIdsFromURL(String.format("/Locations(%s)/Things(%s)/Datastreams", locId, thing.id));
                Assertions.assertEquals(datastreamIDs, dsThingStreamIDs);
                dsThingLocationIDs = this.listIdsFromURL(String.format("/Locations(%s)/Things(%s)/Locations", locId, thing.id));
                Assertions.assertEquals(locationIDs, dsThingLocationIDs);
                dsThingHistoricalLocationIDs = this.listIdsFromURL(String.format("/Locations(%s)/Things(%s)/HistoricalLocations", locId, thing.id));
                Assertions.assertEquals(historicalLocationsIDs, dsThingHistoricalLocationIDs);
            }
            for (Object histLocId : historicalLocationsIDs) {
                dsThingStreamIDs = this.listIdsFromURL(String.format("/HistoricalLocations(%s)/Thing/Datastreams", histLocId));
                Assertions.assertEquals(datastreamIDs, dsThingStreamIDs);
                dsThingLocationIDs = this.listIdsFromURL(String.format("/HistoricalLocations(%s)/Thing/Locations", histLocId));
                Assertions.assertEquals(locationIDs, dsThingLocationIDs);
                dsThingHistoricalLocationIDs = this.listIdsFromURL(String.format("/HistoricalLocations(%s)/Thing/HistoricalLocations", histLocId));
                Assertions.assertEquals(historicalLocationsIDs, dsThingHistoricalLocationIDs);
            }
        }
    }

    @Test
    void testLinksFromLocations() throws IOException, InterruptedException {
        this.createResource(PROVIDER, "sensor", "data", 42);
        this.createResource(PROVIDER, "admin", "location", new Point());
        ResultList<Location> locations = this.utils.queryJson("/Locations", RESULT_LOCATIONS);
        Assertions.assertNotNull(locations);
        Assertions.assertFalse((boolean)locations.value.isEmpty(), (String)"No location found");
        for (Location location : locations.value) {
            Assertions.assertNotNull((Object)location);
            Assertions.assertNotNull((Object)location.id);
            Assertions.assertNotNull((Object)location.name);
            this.utils.assertURLStatus(location.selfLink);
            this.utils.assertDtoEquals(location, this.utils.queryJson(location.selfLink, Location.class), Location.class);
            this.checkSubLinks(location, location.historicalLocationsLink, RESULT_HISTORICAL_LOCATIONS, HistoricalLocation.class);
            this.checkSubLinks(location, location.thingsLink, RESULT_THINGS, Thing.class);
        }
    }

    @Test
    void testLinksFromHistoricalLocations() throws IOException, InterruptedException {
        this.createResource(PROVIDER, "sensor", "data", 42);
        this.session.setResourceValue(PROVIDER, "admin", "location", (Object)"{\"coordinates\": [5.7685,45.192],\"type\": \"Point\"}");
        ResultList<HistoricalLocation> historicalLocations = this.utils.queryJson("/HistoricalLocations", RESULT_HISTORICAL_LOCATIONS);
        Assertions.assertNotNull(historicalLocations);
        Assertions.assertFalse((boolean)historicalLocations.value.isEmpty(), (String)"No historical location found");
        for (HistoricalLocation historicalLocation : historicalLocations.value) {
            Assertions.assertNotNull((Object)historicalLocation);
            Assertions.assertNotNull((Object)historicalLocation.id);
            Assertions.assertNotNull((Object)historicalLocation.time);
            this.utils.assertURLStatus(historicalLocation.selfLink);
            this.utils.assertDtoEquals(historicalLocation, this.utils.queryJson(historicalLocation.selfLink, HistoricalLocation.class), HistoricalLocation.class);
            this.checkSubLinks(historicalLocation, historicalLocation.locationsLink, RESULT_LOCATIONS, Location.class);
            this.utils.assertURLStatus(historicalLocation.thingLink);
        }
    }

    @Test
    void testLinksFromDatastreams() throws IOException, InterruptedException {
        this.createResource(PROVIDER, "sensor", "data", 42);
        ResultList<Datastream> datastreams = this.utils.queryJson("/Datastreams", RESULT_DATASTREAMS);
        Assertions.assertNotNull(datastreams);
        Assertions.assertFalse((boolean)datastreams.value.isEmpty(), (String)"No datastream found");
        for (Datastream datastream : datastreams.value) {
            Assertions.assertNotNull((Object)datastream);
            Assertions.assertNotNull((Object)datastream.id);
            Assertions.assertNotNull((Object)datastream.name);
            Assertions.assertNotNull((Object)datastream.unitOfMeasurement);
            this.utils.assertURLStatus(datastream.selfLink);
            this.utils.assertDtoEquals(datastream, this.utils.queryJson(datastream.selfLink, Datastream.class), Datastream.class);
            this.checkSubLinks(datastream, datastream.observationsLink, RESULT_OBSERVATIONS, Observation.class);
            ObservedProperty obsProp = this.utils.queryJson(datastream.observedPropertyLink, ObservedProperty.class);
            Sensor sensor = this.utils.queryJson(datastream.sensorLink, Sensor.class);
            Thing thing = this.utils.queryJson(datastream.thingLink, Thing.class);
            ResultList<Observation> observations = this.utils.queryJson(datastream.observationsLink, RESULT_OBSERVATIONS);
            Set observationIDs = observations.value.stream().map(o -> o.id).collect(Collectors.toSet());
            for (Observation obs : observations.value) {
                Set<Object> obsDatastreamObsIDs = this.listIdsFromURL(String.format("/Observations(%s)/Datastream/Observations", obs.id));
                Assertions.assertEquals(observationIDs, obsDatastreamObsIDs);
                this.utils.assertDtoEquals(obsProp, this.utils.queryJson(String.format("/Observations(%s)/Datastream/ObservedProperty", obs.id), ObservedProperty.class), ObservedProperty.class);
                this.utils.assertDtoEquals(sensor, this.utils.queryJson(String.format("/Observations(%s)/Datastream/Sensor", obs.id), Sensor.class), Sensor.class);
                this.utils.assertDtoEquals(thing, this.utils.queryJson(String.format("/Observations(%s)/Datastream/Thing", obs.id), Thing.class), Thing.class);
            }
        }
    }

    @Test
    void testLinksFromSensors() throws IOException, InterruptedException {
        this.createResource(PROVIDER, "sensor", "data", 42);
        ResultList<Sensor> sensors = this.utils.queryJson("/Sensors", RESULT_SENSORS);
        Assertions.assertNotNull(sensors);
        Assertions.assertFalse((boolean)sensors.value.isEmpty(), (String)"No sensor found");
        for (Sensor sensor : sensors.value) {
            Assertions.assertNotNull((Object)sensor);
            Assertions.assertNotNull((Object)sensor.id);
            Assertions.assertNotNull((Object)sensor.name);
            this.utils.assertURLStatus(sensor.selfLink);
            this.utils.assertDtoEquals(sensor, this.utils.queryJson(sensor.selfLink, Sensor.class), Sensor.class);
            this.checkSubLinks(sensor, sensor.datastreamsLink, RESULT_DATASTREAMS, Datastream.class);
            Set<Object> datastreamIDs = this.listIdsFromURL(sensor.datastreamsLink);
            for (Object dsId : datastreamIDs) {
                Set<Object> dsStreamIDs = this.listIdsFromURL(String.format("/Datastreams(%s)/Sensor/Datastreams", dsId));
                Assertions.assertEquals(datastreamIDs, dsStreamIDs);
            }
        }
    }

    @Test
    void testLinksFromObservations() throws IOException, InterruptedException {
        this.createResource(PROVIDER, "sensor", "data", 42);
        ResultList<Observation> observations = this.utils.queryJson("/Observations", RESULT_OBSERVATIONS);
        Assertions.assertNotNull(observations);
        Assertions.assertFalse((boolean)observations.value.isEmpty(), (String)"No observation found");
        for (Observation observation : observations.value) {
            Assertions.assertNotNull((Object)observation);
            Assertions.assertNotNull((Object)observation.id);
            Assertions.assertNotNull((Object)observation.phenomenonTime);
            Assertions.assertNotNull((Object)observation.resultTime);
            this.utils.assertURLStatus(observation.selfLink);
            this.utils.assertDtoEquals(observation, this.utils.queryJson(observation.selfLink, Observation.class), Observation.class);
            this.utils.assertURLStatus(observation.datastreamLink);
            this.utils.assertURLStatus(observation.featureOfInterestLink);
        }
    }

    @Test
    void testLinksFromObservedProperties() throws IOException, InterruptedException {
        this.createResource(PROVIDER, "sensor", "data", 42);
        ResultList<ObservedProperty> observedProperties = this.utils.queryJson("/ObservedProperties", new TypeReference<ResultList<ObservedProperty>>(){});
        Assertions.assertNotNull(observedProperties);
        Assertions.assertFalse((boolean)observedProperties.value.isEmpty(), (String)"No observed property found");
        for (ObservedProperty observed : observedProperties.value) {
            Assertions.assertNotNull((Object)observed);
            Assertions.assertNotNull((Object)observed.id);
            Assertions.assertNotNull((Object)observed.name);
            this.utils.assertURLStatus(observed.selfLink);
            this.utils.assertDtoEquals(observed, this.utils.queryJson(observed.selfLink, ObservedProperty.class), ObservedProperty.class);
            this.checkSubLinks(observed, observed.datastreamsLink, RESULT_DATASTREAMS, Datastream.class);
            Set<Object> datastreamIDs = this.listIdsFromURL(observed.datastreamsLink);
            for (Object dsId : datastreamIDs) {
                Set<Object> dsStreamIDs = this.listIdsFromURL(String.format("/Datastreams(%s)/ObservedProperty/Datastreams", dsId));
                Assertions.assertEquals(datastreamIDs, dsStreamIDs);
            }
        }
    }

    @Test
    void testLinksFromFeaturesOfInterest() throws IOException, InterruptedException {
        this.createResource(PROVIDER, "sensor", "data", 42);
        ResultList<FeatureOfInterest> features = this.utils.queryJson("/FeaturesOfInterest", new TypeReference<ResultList<FeatureOfInterest>>(){});
        Assertions.assertNotNull(features);
        Assertions.assertFalse((boolean)features.value.isEmpty(), (String)"No features found");
        for (FeatureOfInterest feature : features.value) {
            Assertions.assertNotNull((Object)feature);
            Assertions.assertNotNull((Object)feature.id);
            Assertions.assertNotNull((Object)feature.name);
            this.utils.assertURLStatus(feature.selfLink);
            this.utils.assertDtoEquals(feature, this.utils.queryJson(feature.selfLink, FeatureOfInterest.class), FeatureOfInterest.class);
            this.checkSubLinks(feature, feature.observationsLink, RESULT_OBSERVATIONS, Observation.class);
            ResultList<Observation> observations = this.utils.queryJson(feature.observationsLink, RESULT_OBSERVATIONS);
            Set observationIDs = observations.value.stream().map(o -> o.id).collect(Collectors.toSet());
            for (Observation obs : observations.value) {
                Set<Object> obsFeaturesObsIDs = this.listIdsFromURL(String.format("/Observations(%s)/FeatureOfInterest/Observations", obs.id));
                Assertions.assertEquals(observationIDs, obsFeaturesObsIDs);
            }
        }
    }
}

