/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.integration;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.rest.integration.AbstractIntegrationTest;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import org.osgi.service.cm.Configuration;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.postgresql.ds.PGSimpleDataSource;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class ObservationHistoryTest
extends AbstractIntegrationTest {
    private static final Instant TS_2012 = Instant.parse("2012-01-01T00:00:00.00Z");
    private static final TypeReference<ResultList<Observation>> RESULT_OBSERVATIONS = new TypeReference<ResultList<Observation>>(){};
    private static JdbcDatabaseContainer<?> container;
    private Configuration historyProviderConfig;

    @BeforeAll
    static void startContainer() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ObservationHistoryTest.class.getClassLoader());
        try {
            try {
                DockerClientFactory.lazyClient().versionCmd().exec();
            }
            catch (Throwable t2) {
                Assumptions.abort((String)"No docker executable on the path, so tests will be skipped");
            }
            container = new PostgreSQLContainer(DockerImageName.parse("timescale/timescaledb-ha").asCompatibleSubstituteFor("postgres").withTag("pg14-latest"));
            container.withDatabaseName("sensinactHistory");
            container.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @BeforeEach
    void setupTest(@InjectConfiguration(withConfig=@WithConfiguration(pid="sensinact.history.timescale", location="?")) Configuration historyConfig, @InjectConfiguration(withConfig=@WithConfiguration(pid="sensinact.sensorthings.northbound.rest", location="?")) Configuration sensorthingsConfig) throws Exception {
        Assertions.assertNotNull(container);
        this.historyProviderConfig = historyConfig;
        historyConfig.update(new Hashtable<String, String>(Map.of("url", container.getJdbcUrl(), "user", container.getUsername(), ".password", container.getPassword())));
        Hashtable<String, String> newProps = new Hashtable<String, String>();
        newProps.put("history.provider", "timescale-history");
        Dictionary properties = sensorthingsConfig.getProperties();
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            newProps.put(key, (String)properties.get(key));
        }
        sensorthingsConfig.update(newProps);
        this.waitForHistoryTables();
        this.waitForSensorthingsAPI();
    }

    private void waitForHistoryTables() {
        boolean ready = false;
        long timeout = System.currentTimeMillis() + 5000L;
        Exception lastError = null;
        while (true) {
            try {
                for (String table : List.of("numeric_data", "text_data", "geo_data")) {
                    this.waitForRowCount("sensinact." + table, 0, true);
                }
                ready = true;
                lastError = null;
            }
            catch (Exception e) {
                lastError = e;
                if (!ready && System.currentTimeMillis() < timeout) continue;
            }
            break;
        }
        Assertions.assertTrue((boolean)ready, (String)("History provider setup timed out: " + lastError));
    }

    private void waitForSensorthingsAPI() {
        boolean ready = false;
        long timeout = System.currentTimeMillis() + 5000L;
        Exception lastError = null;
        while (true) {
            try {
                this.utils.queryJson("/Datastreams", new TypeReference<ResultList<Datastream>>(){});
                ready = true;
                lastError = null;
            }
            catch (Exception e) {
                lastError = e;
                if (!ready && System.currentTimeMillis() < timeout) continue;
            }
            break;
        }
        Assertions.assertTrue((boolean)ready, (String)("SensorThings API setup timed out: " + lastError));
    }

    @AfterEach
    void cleanupTest() throws Exception {
        if (this.historyProviderConfig != null) {
            this.historyProviderConfig.delete();
            this.historyProviderConfig = null;
        }
        try (Connection connection = this.getDataSource().getConnection();){
            Statement stmt = connection.createStatement();
            for (String table : List.of("numeric_data", "text_data", "geo_data")) {
                stmt.execute("DROP TABLE IF EXISTS sensinact." + table);
            }
        }
    }

    @AfterAll
    static void stopContainer() {
        if (container != null) {
            container.stop();
            container = null;
        }
    }

    private PGSimpleDataSource getDataSource() {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setURL(container.getJdbcUrl());
        ds.setUser(container.getUsername());
        ds.setPassword(container.getPassword());
        return ds;
    }

    private void waitForRowCount(String table, int count) {
        this.waitForRowCount(table, count, false);
    }

    private void waitForRowCount(String table, int count, boolean allowMore) {
        int current = -1;
        try (Connection conn = this.getDataSource().getConnection();){
            for (int i = 0; i < 60; ++i) {
                block30: {
                    try (ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + table);){
                        Assertions.assertTrue((boolean)rs.next());
                        current = rs.getInt(1);
                        if (current == count) {
                            return;
                        }
                        if (current <= count) break block30;
                        if (allowMore) {
                            return;
                        }
                        try (ResultSet rs2 = conn.createStatement().executeQuery("SELECT * FROM " + table);){
                            int j = 0;
                            ResultSetMetaData metaData = rs2.getMetaData();
                            int nbCols = metaData.getColumnCount();
                            HashMap<Integer, String> names = new HashMap<Integer, String>();
                            for (int col = 1; col <= nbCols; ++col) {
                                names.put(col, metaData.getColumnName(col));
                            }
                            ArrayList<CallSite> row = new ArrayList<CallSite>(nbCols);
                            while (rs2.next()) {
                                for (int col = 1; col <= nbCols; ++col) {
                                    row.add((CallSite)((Object)((String)names.get(col) + "=" + rs2.getObject(col))));
                                }
                                System.out.println("* " + j++ + " / " + current + " => " + String.join((CharSequence)", ", row));
                                row.clear();
                            }
                            System.out.flush();
                        }
                        throw new AssertionFailedError("The count for table " + table + " was " + current + " which is larger than the expected " + count);
                    }
                }
                Thread.sleep(200L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new AssertionFailedError("Did not reach the required count " + count + " only " + current);
    }

    @Test
    void getDataStreamObservations() throws Exception {
        Instant ts;
        int i;
        int i2;
        for (i2 = 0; i2 < 1000; ++i2) {
            this.createResource("foo", "bar", "baz", String.valueOf(i2), TS_2012.plus(Duration.ofDays(i2)));
        }
        for (i2 = 0; i2 < 4000; ++i2) {
            this.createResource("foo", "bar", "foobar", i2, TS_2012.plus(Duration.ofDays(i2)));
        }
        this.waitForRowCount("sensinact.text_data", 1006);
        this.waitForRowCount("sensinact.numeric_data", 4000);
        ResultList<Observation> observations = this.utils.queryJson("/Datastreams(foo~bar~baz)/Observations?$count=true", RESULT_OBSERVATIONS);
        Assertions.assertEquals((int)1000, (Integer)observations.count);
        Assertions.assertEquals((int)500, (int)observations.value.size());
        Assertions.assertNotNull((Object)observations.nextLink);
        for (i = 0; i < 500; ++i) {
            ts = TS_2012.plus(Duration.ofDays(i));
            Assertions.assertEquals((Object)ts, (Object)((Observation)observations.value.get((int)i)).resultTime);
            Assertions.assertEquals((Object)String.valueOf(i), (Object)((Observation)observations.value.get((int)i)).result);
        }
        observations = this.utils.queryJson(observations.nextLink, RESULT_OBSERVATIONS);
        Assertions.assertEquals((int)1000, (Integer)observations.count);
        Assertions.assertEquals((int)500, (int)observations.value.size());
        Assert.assertNull((Object)observations.nextLink);
        for (i = 0; i < 500; ++i) {
            ts = TS_2012.plus(Duration.ofDays(i + 500));
            Assertions.assertEquals((Object)ts, (Object)((Observation)observations.value.get((int)i)).resultTime);
            Assertions.assertEquals((Object)String.valueOf(i + 500), (Object)((Observation)observations.value.get((int)i)).result);
        }
        observations = this.utils.queryJson("/Datastreams(foo~bar~foobar)/Observations?$count=true", RESULT_OBSERVATIONS);
        Assertions.assertEquals((int)4000, (Integer)observations.count);
        Assertions.assertEquals((int)500, (int)observations.value.size());
        Assertions.assertNotNull((Object)observations.nextLink);
        for (i = 0; i < 500; ++i) {
            ts = TS_2012.plus(Duration.ofDays(i + 1000));
            Assertions.assertEquals((Object)ts, (Object)((Observation)observations.value.get((int)i)).resultTime);
            Assertions.assertEquals((Object)(i + 1000), (Object)((Observation)observations.value.get((int)i)).result);
        }
    }

    @Test
    void getHistoricObservationTest() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.createResource("fizz", "buzz", "fizzbuzz", String.valueOf(i), TS_2012.plus(Duration.ofDays(i)));
        }
        this.waitForRowCount("sensinact.text_data", 16);
        String id = String.format("%s~%s~%s~%s", "fizz", "buzz", "fizzbuzz", Long.toString(TS_2012.plus(Duration.ofDays(3L)).toEpochMilli(), 16));
        Observation o = this.utils.queryJson("/Observations(" + id + ")", new TypeReference<Observation>(){});
        Assertions.assertEquals((Object)id, (Object)o.id);
        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(3L)), (Object)o.resultTime);
        Assertions.assertEquals((Object)"3", (Object)o.result);
    }

    @Test
    void navigateToObservationTest() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.createResource("ding", "dong", "bell", String.valueOf(i), TS_2012.plus(Duration.ofDays(i)));
        }
        this.waitForRowCount("sensinact.text_data", 16);
        ResultList<Datastream> streams = this.utils.queryJson("/Datastreams", new TypeReference<ResultList<Datastream>>(){});
        Assertions.assertFalse((boolean)streams.value.isEmpty());
        Datastream datastream = streams.value.stream().filter(d -> "ding~dong~bell".equals(d.id)).findFirst().get();
        ResultList<Observation> observations = this.utils.queryJson(datastream.observationsLink, new TypeReference<ResultList<Observation>>(){});
        Assertions.assertEquals((int)10, (int)observations.value.size());
        Observation observation = (Observation)observations.value.get(1);
        String id = String.format("%s~%s~%s~%s", "ding", "dong", "bell", Long.toString(TS_2012.plus(Duration.ofDays(1L)).toEpochMilli(), 16));
        Assertions.assertEquals((Object)id, (Object)observation.id);
        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(1L)), (Object)observation.resultTime);
        Assertions.assertEquals((Object)"1", (Object)observation.result);
    }
}

