/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.integration;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    private final Method[] objectMethods = Object.class.getMethods();
    private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    static final HttpClient client = HttpClient.newHttpClient();

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public GenericDto makeDto(String provider, String service, String resource, Object value, Class<?> type) {
        GenericDto dto = new GenericDto();
        dto.model = provider;
        dto.provider = provider;
        dto.service = service;
        dto.resource = resource;
        dto.value = value;
        dto.type = type;
        return dto;
    }

    public HttpResponse<String> query(String path) throws IOException, InterruptedException {
        URI targetUri = path.contains("://") ? URI.create(path) : (path.startsWith("/") ? URI.create("http://localhost:8185/v1.1" + path) : URI.create("http://localhost:8185/v1.1/" + path));
        HttpRequest req = HttpRequest.newBuilder(targetUri).build();
        return client.send(req, x -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
    }

    public <T> T queryJson(String path, TypeReference<T> resultType) throws IOException, InterruptedException {
        HttpResponse<String> response = this.query(path);
        return (T)this.mapper.createParser(response.body()).readValueAs(resultType);
    }

    public <T> T queryJson(String path, final Class<T> resultType) throws IOException, InterruptedException {
        return this.queryJson(path, new TypeReference<T>(){

            public Type getType() {
                return resultType;
            }
        });
    }

    public <T> T queryJson(String path, Object body, Class<T> resultType) throws IOException, InterruptedException {
        URI targetUri = path.startsWith("/") ? URI.create("http://localhost:8185/sensinact" + path) : URI.create("http://localhost:8185/sensinact/" + path);
        HttpRequest req = HttpRequest.newBuilder(targetUri).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString(body))).build();
        HttpResponse response = client.send(req, x -> HttpResponse.BodySubscribers.ofInputStream());
        return (T)this.mapper.createParser((InputStream)response.body()).readValueAs(resultType);
    }

    public void assertNotification(GenericDto expected, ResourceDataNotification notification) {
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)expected.provider, (Object)notification.provider);
        Assertions.assertEquals((Object)expected.service, (Object)notification.service);
        Assertions.assertEquals((Object)expected.resource, (Object)notification.resource);
        Assertions.assertEquals((Object)expected.value, (Object)notification.newValue);
    }

    public void assertURLStatus(String url) {
        this.assertURLStatus(url, 200);
    }

    public void assertURLStatus(String url, int expectedStatusCode) {
        URI targetUri = URI.create(url);
        HttpRequest req = HttpRequest.newBuilder(targetUri).build();
        try {
            HttpResponse response = client.send(req, x -> HttpResponse.BodySubscribers.ofInputStream());
            Assertions.assertEquals((int)expectedStatusCode, (int)response.statusCode(), (String)String.format("Expected <%s> but was: <%s> for URL <%s>", expectedStatusCode, response.statusCode(), url));
        }
        catch (InterruptedException ex) {
            Assertions.fail((String)"HTTP request interrupted");
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)("Error querying URL " + targetUri));
        }
    }

    public void assertDtoEquals(Object expected, Object actual, Class<?> type) {
        this.assertDtoEquals(expected, actual, type, "", null);
    }

    private void assertDtoEquals(Object expected, Object actual, Class<?> type, String path, String message) {
        if (expected == null) {
            Assertions.assertNull((Object)actual, (String)message);
            return;
        }
        Assertions.assertNotNull((Object)actual, (String)message);
        for (Field field : type.getFields()) {
            if ((field.getModifiers() & 8) != 0 || !field.canAccess(expected)) continue;
            try {
                Class<?> fieldType = field.getType();
                Object expectedFieldValue = field.get(expected);
                Object actualFieldValue = field.get(actual);
                if (Arrays.stream(fieldType.getDeclaredMethods()).filter(m4 -> !m4.isSynthetic()).count() == 0L && fieldType.getMethods().length == this.objectMethods.length && fieldType.getFields().length > 0) {
                    this.assertDtoEquals(expectedFieldValue, actualFieldValue, fieldType, path + "/" + field.getName(), String.format("%s: field <%s> (%s) differs: expected <%s> but was <%s>", path + "/" + field.getName(), field.getName(), fieldType.getSimpleName(), expectedFieldValue, actualFieldValue));
                    continue;
                }
                try {
                    Assertions.assertEquals((Object)field.get(expected), (Object)field.get(actual), (String)String.format("%s: field <%s> (%s) differs: expected <%s> but was <%s>", path, field.getName(), fieldType.getSimpleName(), expectedFieldValue, actualFieldValue));
                }
                catch (Throwable t2) {
                    System.out.println("Failed on field:" + field);
                    Assertions.fail((Throwable)t2);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                Assertions.fail((String)"Error comparing DTOs");
            }
        }
    }
}

