/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.integration;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Random;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.integration.AbstractIntegrationTest;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueTest
extends AbstractIntegrationTest {
    private static final String PROVIDER = "valueTester";
    private static final String LOCATION = "{\"coordinates\": [5.7685,45.192],\"type\": \"Point\"}";
    final Random random = new Random();

    @Test
    void testValueUpdate() throws IOException, InterruptedException {
        String svcName = "sensor";
        String rcName = "data";
        int value = this.random.nextInt(1024);
        Instant valueSetInstant = Instant.now();
        this.createResource(PROVIDER, "sensor", "data", value, valueSetInstant);
        this.session.setResourceValue(PROVIDER, "admin", "location", (Object)LOCATION, valueSetInstant);
        Thing thing = this.utils.queryJson("/Things(valueTester)", Thing.class);
        Assertions.assertNotNull((Object)thing, (String)"Thing not found");
        Assertions.assertEquals((Object)PROVIDER, (Object)thing.id);
        String sensorId = String.join((CharSequence)"~", PROVIDER, "sensor", "data");
        Sensor sensor = this.utils.queryJson("/Sensors(" + sensorId + ")", Sensor.class);
        Assertions.assertNotNull((Object)sensor, (String)"Sensor not found");
        Assertions.assertEquals((Object)sensorId, (Object)sensor.id);
        ResultList<Datastream> streams = this.utils.queryJson(sensor.datastreamsLink, new TypeReference<ResultList<Datastream>>(){});
        Assertions.assertEquals((int)1, (int)streams.value.size());
        Datastream stream = (Datastream)streams.value.get(0);
        ResultList<Observation> observations = this.utils.queryJson(stream.observationsLink, new TypeReference<ResultList<Observation>>(){});
        Assertions.assertEquals((int)1, (int)observations.value.size());
        Observation obs = (Observation)observations.value.get(0);
        Assertions.assertEquals((Object)value, (Object)obs.result);
        Instant firstResultTime = obs.resultTime;
        Assertions.assertFalse((boolean)valueSetInstant.isAfter(firstResultTime));
        int newValue = value + this.random.nextInt(1024) + 1;
        Instant valueUpdateInstant = Instant.now();
        this.session.setResourceValue(PROVIDER, "sensor", "data", (Object)newValue);
        observations = this.utils.queryJson(stream.observationsLink, new TypeReference<ResultList<Observation>>(){});
        Assertions.assertEquals((int)1, (int)observations.value.size());
        obs = (Observation)observations.value.get(0);
        Assertions.assertEquals((Object)newValue, (Object)obs.result);
        Assertions.assertTrue((boolean)valueUpdateInstant.isAfter(firstResultTime));
        Assertions.assertFalse((boolean)valueUpdateInstant.isAfter(obs.resultTime));
    }

    @Test
    void testObservationUnit() throws IOException, InterruptedException {
        String svcName = "sensor";
        String rcName = "rcWithUnit";
        int value = this.random.nextInt(1024);
        this.createResource(PROVIDER, "sensor", "rcWithUnit", value);
        Datastream ds = this.utils.queryJson(String.format("/Things(%s)/Datastreams(%s)", PROVIDER, String.join((CharSequence)"~", PROVIDER, "sensor", "rcWithUnit")), Datastream.class);
        Assert.assertNull((Object)ds.unitOfMeasurement.name);
        Assert.assertNull((Object)ds.unitOfMeasurement.symbol);
        Assert.assertNull((Object)ds.unitOfMeasurement.definition);
        String unitName = "degree Celsius";
        String unitSymbol = "\u00b0C";
        String unitDefinition = "http://unitsofmeasure.org/ucum.html#para-30";
        this.session.setResourceMetadata(PROVIDER, "sensor", "rcWithUnit", Map.of("unit", "\u00b0C", "sensorthings.unit.name", "degree Celsius", "sensorthings.unit.definition", "http://unitsofmeasure.org/ucum.html#para-30"));
        ds = this.utils.queryJson(String.format("/Things(%s)/Datastreams(%s)", PROVIDER, String.join((CharSequence)"~", PROVIDER, "sensor", "rcWithUnit")), Datastream.class);
        Assertions.assertEquals((Object)"degree Celsius", (Object)ds.unitOfMeasurement.name);
        Assertions.assertEquals((Object)"\u00b0C", (Object)ds.unitOfMeasurement.symbol);
        Assertions.assertEquals((Object)"http://unitsofmeasure.org/ucum.html#para-30", (Object)ds.unitOfMeasurement.definition);
    }
}

