/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.nortbound.session.integration;

import java.time.Instant;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.nortbound.session.impl.TestUserInfo;
import org.eclipse.sensinact.northbound.security.api.AuthorizationEngine;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.ResourceDescription;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"AUTHENTICATED_ONLY"})})
public class SensinactSessionTest {
    private static final UserInfo ANON = new TestUserInfo("<ANON>", false);
    private static final UserInfo BOB = new TestUserInfo("bob", true);
    private static final String PROVIDER = "SensinactSessionTestProvider";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private Instant timestamp;
    @InjectService
    SensiNactSessionManager sessionManager;
    SensiNactSession anonSession;
    SensiNactSession bobSession;

    @BeforeEach
    void setupProvider(@InjectService DataUpdate push) throws Exception {
        this.timestamp = Instant.now();
        GenericDto dto = new GenericDto();
        dto.provider = PROVIDER;
        dto.service = SERVICE;
        dto.resource = RESOURCE;
        dto.value = 42;
        dto.type = Integer.class;
        dto.timestamp = this.timestamp;
        push.pushUpdate((Object)dto).getValue();
    }

    @AfterEach
    void deleteProvider(@InjectService GatewayThread gt) throws Exception {
        gt.execute((AbstractSensinactCommand)new AbstractTwinCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, PromiseFactory pf) {
                SensinactProvider sp = twin.getProvider(SensinactSessionTest.PROVIDER);
                if (sp != null) {
                    sp.delete();
                }
                return pf.resolved(null);
            }
        }).getValue();
    }

    @BeforeEach
    void start() {
        this.anonSession = this.sessionManager.getDefaultSession(ANON);
        this.bobSession = this.sessionManager.getDefaultSession(BOB);
    }

    @AfterEach
    void stop() {
        this.anonSession.expire();
        this.bobSession.expire();
    }

    @Nested
    class SetTests {
        SetTests() {
        }

        @Test
        void setResourceValue() {
            Instant future = SensinactSessionTest.this.timestamp.plusSeconds(1L);
            Assertions.assertThrows(AuthorizationEngine.NotPermittedException.class, () -> SensinactSessionTest.this.anonSession.setResourceValue(SensinactSessionTest.PROVIDER, "admin", "friendlyName", (Object)"eclipse", future));
            SensinactSessionTest.this.bobSession.setResourceValue(SensinactSessionTest.PROVIDER, "admin", "friendlyName", (Object)"eclipse", future);
            ResourceDescription descr = SensinactSessionTest.this.bobSession.describeResource(SensinactSessionTest.PROVIDER, "admin", "friendlyName");
            Assertions.assertEquals((Object)"eclipse", (Object)descr.value);
            Assertions.assertEquals((Object)future, (Object)descr.timestamp);
        }

        @Test
        void blockSetWithEarlyTimestamp() {
            Assertions.assertThrows(AuthorizationEngine.NotPermittedException.class, () -> SensinactSessionTest.this.anonSession.setResourceValue(SensinactSessionTest.PROVIDER, "admin", "friendlyName", (Object)"foo", SensinactSessionTest.this.timestamp.minusSeconds(1L)));
            SensinactSessionTest.this.bobSession.setResourceValue(SensinactSessionTest.PROVIDER, "admin", "friendlyName", (Object)"foo", SensinactSessionTest.this.timestamp.minusSeconds(1L));
            ResourceDescription descr = SensinactSessionTest.this.bobSession.describeResource(SensinactSessionTest.PROVIDER, "admin", "friendlyName");
            Assertions.assertNotEquals((Object)"foo", (Object)descr.value);
            Assertions.assertEquals((Object)SensinactSessionTest.this.timestamp, (Object)descr.timestamp);
        }
    }

    @Nested
    class DescribeTests {
        DescribeTests() {
        }

        @Test
        void describeResource() {
            Assertions.assertThrows(AuthorizationEngine.NotPermittedException.class, () -> SensinactSessionTest.this.anonSession.describeResource(SensinactSessionTest.PROVIDER, "admin", "friendlyName"));
            ResourceDescription descr = SensinactSessionTest.this.bobSession.describeResource(SensinactSessionTest.PROVIDER, "admin", "friendlyName");
            Assertions.assertEquals((Object)SensinactSessionTest.PROVIDER, (Object)descr.value);
            Assertions.assertEquals((Object)SensinactSessionTest.this.timestamp, (Object)descr.timestamp);
        }

        @Test
        void describeResourceNeverSet() {
            Assertions.assertThrows(AuthorizationEngine.NotPermittedException.class, () -> SensinactSessionTest.this.anonSession.describeResource(SensinactSessionTest.PROVIDER, "admin", "location"));
            ResourceDescription descr = SensinactSessionTest.this.bobSession.describeResource(SensinactSessionTest.PROVIDER, "admin", "location");
            Assertions.assertNull((Object)descr.value);
            Assertions.assertNull((Object)descr.timestamp);
        }
    }

    @Nested
    class GetTests {
        GetTests() {
        }

        @Test
        void getResourceValue() {
            Assertions.assertThrows(AuthorizationEngine.NotPermittedException.class, () -> SensinactSessionTest.this.anonSession.getResourceValue(SensinactSessionTest.PROVIDER, "admin", "friendlyName", String.class));
            String name = (String)SensinactSessionTest.this.bobSession.getResourceValue(SensinactSessionTest.PROVIDER, "admin", "friendlyName", String.class);
            Assertions.assertNotNull((Object)name);
        }

        @Test
        void getResourceNeverSet() {
            Assertions.assertThrows(AuthorizationEngine.NotPermittedException.class, () -> SensinactSessionTest.this.anonSession.getResourceValue(SensinactSessionTest.PROVIDER, "admin", "location", String.class));
            String location = (String)SensinactSessionTest.this.bobSession.getResourceValue(SensinactSessionTest.PROVIDER, "admin", "location", String.class);
            Assertions.assertNull((Object)location);
        }
    }
}

