/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.http.onem2m.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.agent.http.onem2m.internal.OneM2MModelResource;
import org.eclipse.sensinact.gateway.agent.http.onem2m.internal.Util;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneM2MModel {
    private static Logger LOG = LoggerFactory.getLogger((String)OneM2MModel.class.getCanonicalName());
    private String cseBase;
    private Map<String, OneM2MModelResource> model = new HashMap<String, OneM2MModelResource>();
    private static OneM2MModel instance;

    private OneM2MModel(String cseBase) {
        this.cseBase = cseBase;
    }

    public static OneM2MModel getInstance(String cseBase) {
        if (instance == null) {
            LOG.debug("Creating OneM2M model singleton to manage created instance values");
            instance = new OneM2MModel(cseBase);
        }
        return instance;
    }

    private void createModel(String provider, String service, String resource, String value) {
        if (!this.model.keySet().contains(provider)) {
            JSONObject m2mmodel = new JSONObject();
            JSONObject content = new JSONObject();
            content.put("rn", (Object)provider);
            content.put("api", (Object)provider);
            content.put("lbl", (Object)new JSONArray().put((Object)"key1").put((Object)"key2"));
            content.put("rr", false);
            m2mmodel.put("m2m:ae", (Object)content);
            try {
                Util.createRequest(this.cseBase, "POST", "Kentyou" + provider.toUpperCase(), null, "application/json;ty=2", m2mmodel);
            }
            catch (IOException e) {
                LOG.debug("Failed to create application container in OneM2M server", (Throwable)e);
            }
        } else {
            LOG.warn("Container for provider {} already exists, just integrating reading.", (Object)provider);
        }
    }

    public void integrateReading(String provider, String service, String resource, String value) {
        if (!this.model.containsKey(provider)) {
            this.createModel(provider, service, resource, value);
            OneM2MModelResource resourceModel = new OneM2MModelResource(provider, this.cseBase);
            this.model.put(provider, resourceModel);
        }
        this.model.get(provider).addResourceInfo(service, resource, value);
    }

    public void removeProvider(String provider) {
        OneM2MModelResource resourceModel = this.model.remove(provider);
        if (resourceModel != null) {
            try {
                resourceModel.removeResource();
            }
            catch (Exception e) {
                LOG.error("Failed to remove resource container {}", (Object)provider);
            }
            JSONObject content = new JSONObject();
            content.put("rn", (Object)provider);
            try {
                Util.createRequest(this.cseBase, "DELETE", provider, null, "application/json;ty=2", new JSONObject().put("m2m:ae", (Object)content));
            }
            catch (IOException e) {
                LOG.error("Failed to remove AE", (Throwable)e);
            }
        } else {
            LOG.warn("Impossible to remove provider {}, it does not exist in managed list", (Object)provider);
        }
    }
}

