/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.RequestWrapper;

public abstract class AbstractRequestWrapper
implements RequestWrapper {
    protected static final Logger LOG = Logger.getLogger(RequestWrapper.class.getName());
    protected static String RAW_QUERY_PARAMETER = "#RAW#";

    protected static Map<String, List<String>> processRequestQuery(String queryString) throws UnsupportedEncodingException {
        if (queryString == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> queryMap = new HashMap<String, List<String>>();
        char[] characters = queryString.toCharArray();
        int length = characters.length;
        boolean escape = false;
        String name = null;
        String value = null;
        StringBuilder element = new StringBuilder();
        block5: for (int index = 0; index < length; ++index) {
            char c = characters[index];
            if (escape) {
                escape = false;
                element.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    continue block5;
                }
                case '=': {
                    if (name == null) {
                        name = element.toString();
                        element = new StringBuilder();
                        continue block5;
                    }
                    element.append(c);
                    continue block5;
                }
                case '&': {
                    value = element.toString();
                    AbstractRequestWrapper.addParameter(queryMap, name, value);
                    name = null;
                    value = null;
                    element = new StringBuilder();
                    continue block5;
                }
                default: {
                    element.append(c);
                }
            }
        }
        if (name == null && element.length() > 0) {
            name = element.toString();
            AbstractRequestWrapper.addParameter(queryMap, name, Boolean.TRUE.toString());
            return queryMap;
        }
        value = element.toString();
        AbstractRequestWrapper.addParameter(queryMap, name, value);
        return queryMap;
    }

    protected static void addParameter(Map<String, List<String>> map, String name, String value) throws UnsupportedEncodingException {
        List<String> values = map.get(name = name == null || name.length() == 0 ? RAW_QUERY_PARAMETER : URLDecoder.decode(name, "UTF-8"));
        if (values == null) {
            values = new ArrayList<String>();
            map.put(name, values);
        }
        values.add(URLDecoder.decode(value, "UTF-8"));
    }
}

