/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.AbstractResponseWrapper;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.ResponseWrapper;

public class HttpResponseWrapper
extends HttpServletResponseWrapper
implements ResponseWrapper {
    private AbstractResponseWrapper responseWrapper = new AbstractResponseWrapper(){

        @Override
        public void flush() {
            int length;
            if (HttpResponseWrapper.this.isCommitted()) {
                return;
            }
            if (this.attributes != null) {
                for (String name : this.attributes.keySet()) {
                    try {
                        HttpResponseWrapper.this.addHeader(name, AbstractResponseWrapper.getParameter(this.attributes, name));
                    }
                    catch (UnsupportedEncodingException e) {
                        AbstractResponseWrapper.LOG.log(Level.WARNING, e.getMessage());
                    }
                }
            }
            int n = length = this.content == null ? 0 : this.content.length;
            if (length > 0) {
                HttpResponseWrapper.this.setContentLength(length);
                HttpResponseWrapper.this.setBufferSize(length);
                try {
                    ServletOutputStream output = HttpResponseWrapper.this.getOutputStream();
                    output.write(this.content);
                }
                catch (IOException e) {
                    AbstractResponseWrapper.LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (this.statusCode > 0) {
                HttpResponseWrapper.this.setStatus(this.statusCode);
            } else {
                HttpResponseWrapper.this.setStatus(200);
            }
        }
    };

    public HttpResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void setAttributes(Map<String, List<String>> attributes) {
        this.responseWrapper.setAttributes(attributes);
    }

    @Override
    public void setContent(String content) {
        this.responseWrapper.setContent(content);
    }

    @Override
    public void setContent(byte[] bytes) {
        this.responseWrapper.setContent(bytes);
    }

    @Override
    public void setError(Throwable t) {
        this.responseWrapper.setError(t);
    }

    @Override
    public void setError(int status, String message) {
        this.responseWrapper.setError(status, message);
    }

    @Override
    public void setResponseStatus(int status) {
        this.responseWrapper.setResponseStatus(status);
    }

    @Override
    public void flush() {
        this.responseWrapper.flush();
    }
}

