/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback.internal;

import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.CallbackService;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.WebSocketCallbackContext;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.WebSocketRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.WebSocketResponseWrapper;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=65536)
public class CallbackWebSocketServlet {
    private Logger LOG = LoggerFactory.getLogger((String)CallbackWebSocketServlet.class.getName());
    private CallbackService callbackService;
    private Mediator mediator;
    protected Session session;

    protected CallbackWebSocketServlet(Mediator mediator, CallbackService callbackService) {
        this.callbackService = callbackService;
        this.mediator = mediator;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.LOG.debug("new websocket connection was open");
        this.session = session;
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.LOG.debug("");
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        WebSocketCallbackContext context = new WebSocketCallbackContext(this.mediator, new WebSocketRequestWrapper(message), new WebSocketResponseWrapper(this));
        try {
            if (this.callbackService != null) {
                this.callbackService.process(context);
            }
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            this.writeMessage(new JSONObject().put("statusCode", 520).put("message", (Object)"Internal server error").toString());
        }
    }

    @OnWebSocketError
    public void handleError(Throwable error) {
        this.LOG.error("An error occurred:", error);
    }

    protected void close() {
        if (this.session == null) {
            return;
        }
        if (this.session.isOpen()) {
            this.session.close();
        }
        this.session = null;
    }

    public void writeMessage(String message) {
        if (this.session == null || !this.session.isOpen()) {
            return;
        }
        try {
            this.session.getRemote().sendString(message);
        }
        catch (IOException | NullPointerException e) {
            this.LOG.error("An error occurred:", (Throwable)e);
        }
    }
}

