/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.forward.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.sensinact.gateway.nthbnd.http.forward.ForwardingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter
public class ForwardingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingFilter.class);
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    private ForwardingService forwardingService;
    private FilterConfig config;

    public ForwardingFilter(ForwardingService forwardingService) {
        this.forwardingService = forwardingService;
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        LOG.debug("Init with config [" + config + "]");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Request baseRequest = Request.getBaseRequest((ServletRequest)req);
        Response base_response = baseRequest.getResponse();
        base_response.resetForForward();
        HttpURI old_uri = baseRequest.getHttpURI();
        String old_context_path = baseRequest.getContextPath();
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        DispatcherType old_type = baseRequest.getDispatcherType();
        Attributes old_attr = baseRequest.getAttributes();
        MultiMap old_query_params = baseRequest.getQueryParameters();
        baseRequest.setDispatcherType(DispatcherType.FORWARD);
        ForwardAttributes attr = new ForwardAttributes(old_attr);
        if (old_attr.getAttribute("javax.servlet.forward.request_uri") != null) {
            attr._pathInfo = (String)old_attr.getAttribute("javax.servlet.forward.path_info");
            attr._query = (String)old_attr.getAttribute("javax.servlet.forward.query_string");
            attr._requestURI = (String)old_attr.getAttribute("javax.servlet.forward.request_uri");
            attr._contextPath = (String)old_attr.getAttribute("javax.servlet.forward.context_path");
            attr._servletPath = (String)old_attr.getAttribute("javax.servlet.forward.servlet_path");
        } else {
            attr._pathInfo = old_path_info;
            attr._query = old_uri.getQuery();
            attr._requestURI = old_uri.getPath();
            attr._contextPath = old_context_path;
            attr._servletPath = old_servlet_path;
        }
        String query = this.forwardingService.getQuery((HttpServletRequest)baseRequest);
        String path = this.forwardingService.getUri((HttpServletRequest)baseRequest);
        String param = this.forwardingService.getParam((HttpServletRequest)baseRequest);
        String fragment = this.forwardingService.getFragment((HttpServletRequest)baseRequest);
        HttpURI uri = new HttpURI(old_uri.getScheme(), old_uri.getHost(), old_uri.getPort(), path, param, query, fragment);
        baseRequest.setHttpURI(uri);
        baseRequest.setContextPath(this.config.getServletContext().getContextPath());
        baseRequest.setServletPath(null);
        baseRequest.setPathInfo(path);
        if (query != null || old_uri.getQuery() != null) {
            baseRequest.mergeQueryParameters(old_uri.getQuery(), query, true);
        }
        baseRequest.setAttributes((Attributes)attr);
        if (attr._query != null) {
            baseRequest.mergeQueryParameters(baseRequest.getQueryString(), attr._query, false);
        }
        baseRequest.setAttributes((Attributes)attr);
        RequestDispatcher d = this.config.getServletContext().getRequestDispatcher(path);
        d.forward(req, res);
    }

    public void destroy() {
        LOG.debug("Destroyed filter");
    }

    private class ForwardAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (key.equals("javax.servlet.forward.path_info")) {
                return this._pathInfo;
            }
            if (key.equals("javax.servlet.forward.request_uri")) {
                return this._requestURI;
            }
            if (key.equals("javax.servlet.forward.servlet_path")) {
                return this._servletPath;
            }
            if (key.equals("javax.servlet.forward.context_path")) {
                return this._contextPath;
            }
            if (key.equals("javax.servlet.forward.query_string")) {
                return this._query;
            }
            if (key.startsWith(ForwardingFilter.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration<String> getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.startsWith(ForwardingFilter.__INCLUDE_PREFIX) || name.startsWith(ForwardingFilter.__FORWARD_PREFIX)) continue;
                set.add(name);
            }
            if (this._pathInfo != null) {
                set.add("javax.servlet.forward.path_info");
            } else {
                set.remove("javax.servlet.forward.path_info");
            }
            set.add("javax.servlet.forward.request_uri");
            set.add("javax.servlet.forward.servlet_path");
            set.add("javax.servlet.forward.context_path");
            if (this._query != null) {
                set.add("javax.servlet.forward.query_string");
            } else {
                set.remove("javax.servlet.forward.query_string");
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (key.startsWith("javax.servlet.")) {
                if (key.equals("javax.servlet.forward.path_info")) {
                    this._pathInfo = (String)value;
                } else if (key.equals("javax.servlet.forward.request_uri")) {
                    this._requestURI = (String)value;
                } else if (key.equals("javax.servlet.forward.servlet_path")) {
                    this._servletPath = (String)value;
                } else if (key.equals("javax.servlet.forward.context_path")) {
                    this._contextPath = (String)value;
                } else if (key.equals("javax.servlet.forward.query_string")) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        public void clearAttributes() {
            this._attr.clearAttributes();
            this._requestURI = null;
            this._contextPath = null;
            this._servletPath = null;
            this._pathInfo = null;
            this._query = null;
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }

        public Set<String> getAttributeNameSet() {
            return this._attr.getAttributeNameSet();
        }
    }
}

