/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.mqtt.inst.test;

import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.sensinact.gateway.core.AnonymousSession;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.simulated.slider.api.SliderSetterItf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithFactoryConfiguration;
import org.osgi.test.common.annotation.config.WithFactoryConfigurations;
import org.osgi.test.junit5.cm.ConfigurationExtension;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

@Extensions(value={@ExtendWith(value={BundleContextExtension.class}), @ExtendWith(value={ConfigurationExtension.class}), @ExtendWith(value={ServiceExtension.class})})
public class MQTTAgentTest {
    private final BlockingQueue<String> events = new ArrayBlockingQueue<String>(16);
    private static final String PORT = "1884";

    @Test
    @WithFactoryConfigurations(value={@WithFactoryConfiguration(factoryPid="mqtt.agent.broker", name="ag1", location="?", properties={@Property(key="port", value={"1884"}), @Property(key="qos", value={"1"})}), @WithFactoryConfiguration(factoryPid="mqtt.server", name="ag1", location="?", properties={@Property(key="port", value={"1884"}), @Property(key="autostart", value={"true"})})})
    public void mqttAgentsTest(@InjectService SliderSetterItf slider, @InjectService Core core) throws Throwable {
        Thread.sleep(5000L);
        try (MqttClient client = new MqttClient("tcp://127.0.0.1:1884", UUID.randomUUID().toString(), (MqttClientPersistence)new MemoryPersistence());){
            client.setCallback(new MqttCallback(){

                public void connectionLost(Throwable cause) {
                    cause.printStackTrace();
                }

                public void messageArrived(String topic, MqttMessage message) throws Exception {
                    String m = "[" + topic + "]" + message;
                    MQTTAgentTest.this.events.offer(m);
                    System.out.println(m);
                }

                public void deliveryComplete(IMqttDeliveryToken token) {
                }
            });
            client.connect();
            client.subscribe("/slider/cursor/position");
            AnonymousSession session = core.getAnonymousSession();
            Integer value = this.getSliderValue(session);
            int targetValue = value == 0 ? 5 : 0;
            slider.move(targetValue);
            Assertions.assertEquals((int)targetValue, (Integer)this.getSliderValue(session));
            Assertions.assertEquals((Object)("[/slider/cursor/position]" + targetValue), (Object)this.events.poll(2L, TimeUnit.SECONDS));
            slider.move(45);
            Assertions.assertEquals((int)45, (Integer)this.getSliderValue(session));
            Assertions.assertEquals((Object)"[/slider/cursor/position]45", (Object)this.events.poll(2L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)this.events.isEmpty());
            client.disconnect(500L);
        }
    }

    private Integer getSliderValue(AnonymousSession session) {
        GetResponse getResponse = session.get("slider", "cursor", "position", "value", new Object[0]);
        Integer value = (Integer)getResponse.getResponse("value");
        return value;
    }
}

