/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.mqtt.generic.internal;

import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericMqttAgent {
    private static final Logger LOG = LoggerFactory.getLogger(GenericMqttAgent.class);
    private final String broker;
    private final int qos;
    private final String username;
    private final String password;
    private MqttClient client;

    public GenericMqttAgent(String broker, int qos, String prefix) throws IOException {
        this(broker, qos, prefix, null, null);
    }

    public GenericMqttAgent(String broker, int qos, String prefix, String username, String password) throws IOException {
        LOG.debug("Connecting to broker {} with QoS {} and prefix {}", new Object[]{broker, qos, prefix});
        this.broker = broker;
        this.qos = qos;
        this.username = username;
        this.password = password;
    }

    private void connect() {
        MqttConnectOptions connOpts = new MqttConnectOptions();
        if (this.username != null && this.password != null) {
            connOpts.setUserName(this.username);
            connOpts.setPassword(this.password.toCharArray());
        }
        connOpts.setCleanSession(true);
        try {
            this.client = new MqttClient(this.broker, MqttClient.generateClientId(), (MqttClientPersistence)new MemoryPersistence());
            this.client.connect(connOpts);
        }
        catch (MqttException me) {
            LOG.error("reason " + me.getReasonCode());
            LOG.error("msg " + me.getMessage());
            LOG.error("loc " + me.getLocalizedMessage());
            LOG.error("cause " + me.getCause());
            LOG.error("except " + (Object)((Object)me));
            me.printStackTrace();
        }
    }

    public void publish(String topic, String message) {
        MqttMessage mqMessage = new MqttMessage(message.getBytes());
        mqMessage.setQos(this.qos);
        this.publish(topic, mqMessage);
    }

    public void publish(String topic, MqttMessage message) {
        if (this.client == null) {
            this.connect();
        }
        try {
            this.client.publish(topic, message);
        }
        catch (MqttPersistenceException me) {
            LOG.error("reason " + me.getReasonCode());
            LOG.error("msg " + me.getMessage());
            LOG.error("loc " + me.getLocalizedMessage());
            LOG.error("cause " + me.getCause());
            LOG.error("except " + (Object)((Object)me));
            me.printStackTrace();
        }
        catch (MqttException me) {
            this.client = null;
            LOG.error("reason " + me.getReasonCode());
            LOG.error("msg " + me.getMessage());
            LOG.error("loc " + me.getLocalizedMessage());
            LOG.error("cause " + me.getCause());
            LOG.error("except " + (Object)((Object)me));
            me.printStackTrace();
        }
    }

    public void close() {
        try {
            this.client.disconnect();
        }
        catch (MqttException me) {
            LOG.error("reason " + me.getReasonCode());
            LOG.error("msg " + me.getMessage());
            LOG.error("loc " + me.getLocalizedMessage());
            LOG.error("cause " + me.getCause());
            LOG.error("except " + (Object)((Object)me));
            me.printStackTrace();
        }
    }

    public String getBroker() {
        return this.broker;
    }

    public int getQos() {
        return this.qos;
    }
}

