/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.sensinact.gateway.util.IOUtils;

public class JettyTestServer
implements Runnable {
    private final Server server;
    private ServerConnector connector;
    private int port;
    private String message;
    private boolean available;
    private boolean running = false;

    public JettyTestServer(int port) throws Exception {
        this.port = port;
        this.server = new Server((ThreadPool)new ExecutorThreadPool(10));
    }

    public boolean isStarted() {
        return this.running;
    }

    public void start() throws Exception {
        ServletHolder holder = new ServletHolder((Servlet)new JettyTestServerCallbackServlet());
        holder.setName("callbackServlet");
        ServletHandler handler = new ServletHandler();
        handler.addServletWithMapping(holder, "/");
        this.server.setHandler((Handler)handler);
        this.connector = new ServerConnector(this.server);
        this.connector.setPort(this.port);
        this.connector.addConnectionFactory(new ConnectionFactory(){

            public String getProtocol() {
                return "HTTP";
            }

            public Connection newConnection(Connector connector, EndPoint endpoint) {
                return endpoint.getConnection();
            }

            public List<String> getProtocols() {
                return Arrays.asList("HTTP");
            }
        });
        this.server.setConnectors(new Connector[]{this.connector});
        this.server.start();
    }

    public void stop() throws Exception {
        if (this.connector != null) {
            this.connector.stop();
        }
        this.server.stop();
    }

    public void dump() throws Exception {
        this.server.dumpStdErr();
    }

    public void join() throws Exception {
        if (this.connector != null) {
            this.connector.join();
        }
        Thread.sleep(2000L);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public String getResponseMessage() {
        return this.message;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = false;
    }

    public class JettyTestServerCallbackServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            System.out.println("GETTING ...");
            if (response.isCommitted()) {
                return;
            }
            final AsyncContext asyncContext = request.isAsyncStarted() ? request.getAsyncContext() : request.startAsync((ServletRequest)request, (ServletResponse)response);
            response.getOutputStream().setWriteListener(new WriteListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onWritePossible() throws IOException {
                    HttpServletRequest request = (HttpServletRequest)asyncContext.getRequest();
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    try {
                        JettyTestServer.this.message = null;
                        JettyTestServer.this.setAvailable(true);
                        response.setStatus(200);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        response.sendError(520, "Internal server error");
                    }
                    finally {
                        if (request.isAsyncStarted()) {
                            asyncContext.complete();
                        }
                    }
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                }
            });
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (response.isCommitted()) {
                return;
            }
            final AsyncContext asyncContext = request.isAsyncStarted() ? request.getAsyncContext() : request.startAsync((ServletRequest)request, (ServletResponse)response);
            response.getOutputStream().setWriteListener(new WriteListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onWritePossible() throws IOException {
                    HttpServletRequest request = (HttpServletRequest)asyncContext.getRequest();
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    try {
                        JettyTestServer.this.message = null;
                        int length = request.getContentLength();
                        if (length > -1) {
                            byte[] content = IOUtils.read((InputStream)request.getInputStream(), (int)length, (boolean)false);
                            JettyTestServer.this.message = new String(content);
                        } else {
                            byte[] content = IOUtils.read((InputStream)request.getInputStream(), (boolean)false);
                            JettyTestServer.this.message = new String(content);
                        }
                        JettyTestServer.this.setAvailable(true);
                        response.setStatus(200);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        response.sendError(520, "Internal server error");
                    }
                    finally {
                        if (request.isAsyncStarted()) {
                            asyncContext.complete();
                        }
                    }
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                }
            });
        }
    }
}

