/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.component;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.interpolator.Interpolator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.http.CorsFilter;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.http.HttpEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.http.HttpLoginEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.http.HttpRegisteringEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws.WebSocketConnectionFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.http.whiteboard.annotations.RequireHttpWhiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@RequireHttpWhiteboard
public class RestAccessConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(RestAccessConfigurator.class);
    private CorsFilter corsFilter = null;
    private boolean corsHeader = false;
    private NorthboundMediator mediator;
    private static ClassLoader loader = null;

    private static void findJettyClassLoader(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            if (!"org.apache.felix.http.jetty".equals(bundle.getSymbolicName())) continue;
            try {
                BundleWiring wire = (BundleWiring)bundle.adapt(BundleWiring.class);
                loader = wire.getClassLoader();
            }
            catch (Exception e) {
                e.printStackTrace();
                loader = WebSocketServlet.class.getClassLoader();
            }
            break;
        }
    }

    protected void injectPropertyFields() throws Exception {
        LOG.debug("Starting introspection in bundle %s", (Object)this.mediator.getContext().getBundle().getSymbolicName());
        Interpolator interpolator = new Interpolator((Mediator)this.mediator);
        interpolator.getInstance((Object)this);
        for (Map.Entry entry : interpolator.getPropertiesInjected().entrySet()) {
            if (this.mediator.getProperties().containsKey(entry.getKey())) continue;
            this.mediator.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    @Activate
    public void activate(ComponentContext componentContext) throws Exception {
        this.mediator = new NorthboundMediator(componentContext.getBundleContext());
        this.injectPropertyFields();
        RestAccessConfigurator.findJettyClassLoader(this.mediator.getContext());
        this.corsHeader = Boolean.valueOf((String)this.mediator.getProperty("org.eclipse.sensinact.http.corsheader"));
        if (this.corsHeader) {
            this.corsFilter = new CorsFilter();
            this.mediator.register((Object)this.corsFilter, Filter.class, (Dictionary)new Hashtable<String, Object>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("service.ranking", 1);
                    this.put("osgi.http.whiteboard.filter.pattern", "/*");
                    this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
                }
            });
        }
        this.mediator.register((Dictionary)new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("osgi.http.whiteboard.servlet.pattern", "/ws/sensinact");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
            }
        }, (Object)new WebSocketServlet(){
            private static final long serialVersionUID = 1L;
            private WebSocketConnectionFactory sessionPool;
            private final AtomicBoolean firstCall;
            private final CountDownLatch initBarrier;
            {
                this.sessionPool = new WebSocketConnectionFactory(RestAccessConfigurator.this.mediator);
                this.firstCall = new AtomicBoolean(true);
                this.initBarrier = new CountDownLatch(1);
            }

            public void init() throws ServletException {
                LOG.info("The Echo servlet has been initialized, but we delay initialization until the first request so that a Jetty Context is available");
            }

            public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
                if (this.firstCall.compareAndSet(true, false)) {
                    try {
                        this.delayedInit();
                    }
                    finally {
                        this.initBarrier.countDown();
                    }
                }
                try {
                    this.initBarrier.await();
                }
                catch (InterruptedException e) {
                    throw new ServletException("Timed out waiting for initialisation", (Throwable)e);
                }
                super.service(arg0, arg1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void delayedInit() throws ServletException {
                Thread currentThread = Thread.currentThread();
                ClassLoader tccl = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(loader);
                try {
                    super.init();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    currentThread.setContextClassLoader(tccl);
                }
            }

            public void configure(WebSocketServletFactory factory) {
                factory.getPolicy().setIdleTimeout(3600000L);
                factory.setCreator((WebSocketCreator)this.sessionPool);
            }
        }, new Class[]{Servlet.class, WebSocketServlet.class});
        LOG.info(String.format("%s servlet registered", "/ws/sensinact"));
        this.mediator.register((Object)new HttpLoginEndpoint(this.mediator), Servlet.class, (Dictionary)new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("osgi.http.whiteboard.servlet.pattern", "/sensinact.login");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
            }
        });
        LOG.info(String.format("%s servlet registered", "/sensinact.login"));
        this.mediator.register((Object)new HttpRegisteringEndpoint(this.mediator), Servlet.class, (Dictionary)new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("osgi.http.whiteboard.servlet.pattern", "/sensinact.register");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
            }
        });
        LOG.info(String.format("%s servlet registered", "/sensinact.register"));
        this.mediator.register((Object)new HttpEndpoint(this.mediator), Servlet.class, (Dictionary)new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("osgi.http.whiteboard.servlet.pattern", "/sensinact/*");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
            }
        });
        LOG.info(String.format("%s servlet registered", "/sensinact/*"));
    }

    @Deactivate
    public void deactivate() throws Exception {
    }
}

