/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.nthbnd.rest.http.test.HttpServiceTestClient;
import org.eclipse.sensinact.gateway.nthbnd.rest.server.JettyTestServer;
import org.eclipse.sensinact.gateway.nthbnd.rest.ws.test.WsServiceTestClient;
import org.eclipse.sensinact.gateway.simulated.slider.api.SliderSetterItf;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

@Extensions(value={@ExtendWith(value={BundleContextExtension.class}), @ExtendWith(value={ServiceExtension.class})})
public class TestRestSUBSCRIBE_UNSUBSCRIBEAccess {
    private static JettyTestServer server = null;

    @BeforeAll
    public static void initialization() throws Exception {
        if (server != null) {
            if (server.isStarted()) {
                server.stop();
                server.join();
            }
            server = null;
        }
        server = new JettyTestServer(8898);
        new Thread(server).start();
        server.join();
    }

    @AfterAll
    public static void finalization() throws Exception {
        server.stop();
        server.join();
    }

    @Test
    public void testHttpAccessMethodSUBSCRIBE_UNSUBSCIBE(@InjectBundleContext BundleContext context, @InjectService(timeout=500L) SliderSetterItf slider) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/cursor/resources/position/SUBSCRIBE", "{\"parameters\" : [{\"name\":\"callback\", \"type\":\"string\",\"value\":\"http://localhost:8898\"}]}", "POST");
        System.out.println(simulated);
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        String subscriptionId = response.getJSONObject("response").getString("subscriptionId");
        server.setAvailable(false);
        Thread.sleep(5000L);
        slider.move(2);
        String message = this.waitForAvailableMessage(10000L);
        Assertions.assertNotNull((Object)message);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)2, (int)response.getJSONObject("notification").getInt("value"));
        server.setAvailable(false);
        Thread.sleep(5000L);
        slider.move(0);
        message = this.waitForAvailableMessage(10000L);
        System.out.println(message);
        Assertions.assertNotNull((Object)message);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)0, (int)response.getJSONObject("notification").getInt("value"));
        server.setAvailable(false);
        Thread.sleep(5000L);
        slider.move(100);
        message = this.waitForAvailableMessage(10000L);
        Assertions.assertNotNull((Object)message);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)100, (int)response.getJSONObject("notification").getInt("value"));
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/cursor/resources/position/UNSUBSCRIBE", "{\"parameters\" : [{\"name\":\"subscriptionId\", \"type\":\"string\", \"value\":\"" + subscriptionId + "\"}]}", "POST");
        System.out.println(simulated);
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        server.setAvailable(false);
        Thread.sleep(5000L);
        slider.move(150);
        message = this.waitForAvailableMessage(10000L);
        Assertions.assertNull((Object)message);
    }

    @Test
    public void testHttpAccessMethodConditionalSUBSCRIBE_UNSUBSCIBE(@InjectBundleContext BundleContext context, @InjectService(timeout=500L) SliderSetterItf slider) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/cursor/resources/position/SUBSCRIBE", "{\"parameters\" : [{\"name\":\"callback\", \"type\":\"string\",\"value\":\"http://127.0.0.1:8898\"},{\"name\":\"conditions\",\"type\":\"array\",\"value\":[{\"operator\":\"<\",\"operand\":200, \"type\":\"int\", \"complement\":false}]}]}", "POST");
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        String subscriptionId = response.getJSONObject("response").getString("subscriptionId");
        server.setAvailable(false);
        slider.move(2);
        String message = this.waitForAvailableMessage(10000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)2, (int)response.getJSONObject("notification").getInt("value"));
        server.setAvailable(false);
        slider.move(200);
        message = this.waitForAvailableMessage(10000L);
        Assertions.assertNull((Object)message);
        server.setAvailable(false);
        slider.move(199);
        message = this.waitForAvailableMessage(10000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)199, (int)response.getJSONObject("notification").getInt("value"));
        server.setAvailable(false);
        slider.move(201);
        message = this.waitForAvailableMessage(10000L);
        Assertions.assertNull((Object)message);
        server.setAvailable(false);
        slider.move(185);
        message = this.waitForAvailableMessage(10000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)185, (int)response.getJSONObject("notification").getInt("value"));
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/cursor/resources/position/UNSUBSCRIBE", "{\"parameters\" : [{\"name\":\"subscriptionId\", \"type\":\"string\", \"value\":\"" + subscriptionId + "\"}]}", "POST");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        server.setAvailable(false);
        slider.move(150);
        message = this.waitForAvailableMessage(10000L);
        Assertions.assertNull((Object)message);
    }

    @Test
    public void testWsAccessMethodSUBSCRIBE_UNSUBSCIBE(@InjectService(timeout=500L) SliderSetterItf slider) throws Exception {
        WsServiceTestClient client = new WsServiceTestClient();
        new Thread(client).start();
        String simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/cursor/resources/position/SUBSCRIBE", null);
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        String subscriptionId = response.getJSONObject("response").getString("subscriptionId");
        client.setAvailable(false);
        slider.move(2);
        String message = this.waitForAvailableMessage(client, 1000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)2, (int)response.getJSONObject("notification").getInt("value"));
        client.setAvailable(false);
        slider.move(0);
        message = this.waitForAvailableMessage(client, 1000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)0, (int)response.getJSONObject("notification").getInt("value"));
        client.setAvailable(false);
        slider.move(125);
        message = this.waitForAvailableMessage(client, 1000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)125, (int)response.getJSONObject("notification").getInt("value"));
        simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/cursor/resources/position/UNSUBSCRIBE", "[{\"name\":\"subscriptionId\", \"type\":\"string\", \"value\":\"" + subscriptionId + "\"}]");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        client.setAvailable(false);
        slider.move(150);
        message = this.waitForAvailableMessage(client, 1000L);
        Assertions.assertNull((Object)message);
    }

    @Test
    public void testWsAccessMethodConditionalSUBSCRIBE_UNSUBSCIBE(@InjectService(timeout=500L) SliderSetterItf slider) throws Exception {
        WsServiceTestClient client = new WsServiceTestClient();
        new Thread(client).start();
        String simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/cursor/resources/position/SUBSCRIBE", "[{\"name\":\"conditions\",\"type\":\"array\",\"value\":[{\"operator\":\"<\",\"operand\":200, \"type\":\"int\", \"complement\":false}]}]");
        System.out.println(simulated);
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        String subscriptionId = response.getJSONObject("response").getString("subscriptionId");
        client.setAvailable(false);
        slider.move(2);
        String message = this.waitForAvailableMessage(client, 1000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)2, (int)response.getJSONObject("notification").getInt("value"));
        client.setAvailable(false);
        slider.move(200);
        message = this.waitForAvailableMessage(client, 1000L);
        Assertions.assertNull((Object)message);
        client.setAvailable(false);
        slider.move(199);
        message = this.waitForAvailableMessage(client, 1000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)199, (int)response.getJSONObject("notification").getInt("value"));
        client.setAvailable(false);
        slider.move(201);
        message = this.waitForAvailableMessage(client, 1000L);
        Assertions.assertNull((Object)message);
        client.setAvailable(false);
        slider.move(185);
        message = this.waitForAvailableMessage(client, 1000L);
        response = new JSONObject(message);
        response = response.getJSONArray("messages").getJSONObject(0);
        Assertions.assertEquals((int)185, (int)response.getJSONObject("notification").getInt("value"));
        simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/cursor/resources/position/UNSUBSCRIBE", "[{\"name\":\"subscriptionId\", \"type\":\"string\", \"value\":\"" + subscriptionId + "\"}]");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        client.setAvailable(false);
        slider.move(150);
        message = this.waitForAvailableMessage(client, 1000L);
        Assertions.assertNull((Object)message);
    }

    private String waitForAvailableMessage(long delay) {
        String message = null;
        long wait = delay;
        while (!server.isAvailable() && wait > 0L) {
            try {
                Thread.sleep(100L);
                wait -= 100L;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (server.isAvailable()) {
            message = server.getResponseMessage();
        }
        return message;
    }

    private String synchronizedRequest(WsServiceTestClient client, String url, String content) {
        client.newRequest(url, content);
        String message = this.waitForAvailableMessage(client, 10000L);
        return message;
    }

    private String waitForAvailableMessage(WsServiceTestClient client, long delay) {
        String message = null;
        long wait = delay;
        while (!client.isAvailable() && wait > 0L) {
            wait -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (client.isAvailable()) {
            message = client.getResponseMessage();
        }
        return message;
    }
}

