/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws.WebSocketConnection;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws.WebSocketRecipient;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsRestAccessRequest
implements NorthboundRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(WsRestAccessRequest.class);
    private NorthboundMediator mediator;
    private JSONObject request;
    private String content;
    private WebSocketConnection wsConnection;

    public WsRestAccessRequest(NorthboundMediator mediator, WebSocketConnection wsConnection, JSONObject request) {
        this.request = request;
        this.mediator = mediator;
        this.wsConnection = wsConnection;
    }

    public NorthboundMediator getMediator() {
        return this.mediator;
    }

    public String getRequestIdProperty() {
        return "rid";
    }

    public String getRequestId() {
        return (String)this.request.opt(this.getRequestIdProperty());
    }

    public String getRequestURI() {
        String uri = this.request.optString("uri");
        String[] uriElements = uri.split("\\?");
        return uriElements[0];
    }

    public Map<NorthboundRequestWrapper.QueryKey, List<String>> getQueryMap() {
        String uri = this.request.optString("uri");
        String[] uriElements = uri.split("\\?");
        if (uriElements.length == 2) {
            try {
                return NorthboundRequest.processRequestQuery((String)uriElements[1]);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    public String getContent() {
        if (this.content == null) {
            JSONArray parameters = this.request.optJSONArray("parameters");
            if (parameters == null) {
                parameters = new JSONArray();
            }
            this.content = parameters.toString();
        }
        return this.content;
    }

    public Authentication<?> getAuthentication() {
        return null;
    }

    public NorthboundRecipient createRecipient(List<Parameter> parameters) {
        return new WebSocketRecipient((Mediator)this.mediator, this.wsConnection);
    }
}

