/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.nthbnd.rest.http.test.HttpServiceTestClient;
import org.eclipse.sensinact.gateway.nthbnd.rest.ws.test.WsServiceTestClient;
import org.eclipse.sensinact.gateway.simulated.slider.api.SliderSetterItf;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;
import org.skyscreamer.jsonassert.JSONAssert;

@Extensions(value={@ExtendWith(value={BundleContextExtension.class}), @ExtendWith(value={ServiceExtension.class})})
public class TestRestGETAccess {
    @InjectBundleContext
    BundleContext context;

    @BeforeEach
    public void before() {
        Mediator mediator = new Mediator(this.context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/admin/resources/location/SET", "{\"parameters\":[{\"name\": \"location\",\"value\": \"45.2:5.7\",\"type\": \"string\"}]}", "POST");
        JSONObject response = new JSONObject(simulated);
        Assertions.assertEquals((Object)200, (Object)response.get("statusCode"));
    }

    @Test
    public void testHttpAccessMethodRawDescription() throws Exception {
        Mediator mediator = new Mediator(this.context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers?rawDescribe=true", null, "GET");
        System.out.println(simulated);
        JSONArray response = new JSONArray("[\"slider\",\"light\"]");
        JSONAssert.assertEquals(response, new JSONArray(simulated), false);
    }

    @Test
    public void testHttpRoot(@InjectBundleContext BundleContext context) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact", null, "GET");
        JSONObject response = new JSONObject("{\"providers\":[{\"name\":\"slider\",\"location\":\"45.2:5.7\",\"services\":[{\"name\":\"admin\",\"resources\":[{\"name\":\"friendlyName\",\"type\":\"PROPERTY\"},{\"name\":\"location\",\"type\":\"PROPERTY\"},{\"name\":\"bridge\",\"type\":\"PROPERTY\"},{\"name\":\"icon\",\"type\":\"PROPERTY\"}]},{\"name\":\"cursor\",\"resources\":[{\"name\":\"position\",\"type\":\"SENSOR\"}]}]},{\"name\":\"light\",\"location\":\"45.2:5.7\",\"services\":[{\"name\":\"admin\",\"resources\":[{\"name\":\"friendlyName\",\"type\":\"PROPERTY\"},{\"name\":\"location\",\"type\":\"PROPERTY\"},{\"name\":\"bridge\",\"type\":\"PROPERTY\"},{\"name\":\"icon\",\"type\":\"PROPERTY\"}]},{\"name\":\"switch\",\"resources\":[{\"name\":\"status\",\"type\":\"STATE_VARIABLE\"},{\"name\":\"brightness\",\"type\":\"STATE_VARIABLE\"},{\"name\":\"turn_on\",\"type\":\"ACTION\"},{\"name\":\"turn_off\",\"type\":\"ACTION\"},{\"name\":\"dim\",\"type\":\"ACTION\"}]}]}],\"type\":\"COMPLETE_LIST\",\"uri\":\"/\",\"statusCode\":200}");
        JSONAssert.assertEquals(response, new JSONObject(simulated), false);
    }

    @Test
    public void testHttpAccessMethodGET(@InjectBundleContext BundleContext context, @InjectService(timeout=500L) SliderSetterItf slider) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers", null, "GET");
        System.out.println(simulated);
        JSONObject response = new JSONObject("{\"statusCode\":200,\"providers\":[\"slider\",\"light\"],\"type\":\"PROVIDERS_LIST\",\"uri\":\"/\"}");
        JSONAssert.assertEquals(response, new JSONObject(simulated), false);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services", null, "GET");
        System.out.println(simulated);
        response = new JSONObject(simulated);
        JSONArray array = response.getJSONArray("services");
        Assertions.assertTrue((array.length() == 2 ? 1 : 0) != 0);
        JSONAssert.assertEquals(new JSONArray("[\"admin\",\"cursor\"]"), array, false);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/cursor/resources", null, "GET");
        response = new JSONObject(simulated);
        array = response.getJSONArray("resources");
        JSONAssert.assertEquals(new JSONArray("[\"position\"]"), array, false);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/cursor/resources/position", null, "GET");
        slider.move(1);
        Thread.sleep(1000L);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/cursor/resources/position/GET", null, "GET");
        response = new JSONObject(simulated);
        System.out.println(response);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals(1));
    }

    @Test
    public void testSimplifiedHttpAccessMethodGET(@InjectBundleContext BundleContext context, @InjectService(timeout=500L) SliderSetterItf slider) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/slider", null, "GET");
        System.out.println(simulated);
        JSONObject response = new JSONObject(simulated).getJSONObject("response");
        JSONArray array = response.getJSONArray("services");
        Assertions.assertTrue((array.length() == 2 ? 1 : 0) != 0);
        JSONAssert.assertEquals(new JSONArray("[\"admin\",\"cursor\"]"), array, false);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/slider/cursor", null, "GET");
        response = new JSONObject(simulated).getJSONObject("response");
        array = response.getJSONArray("resources");
        JSONAssert.assertEquals(new JSONArray("[{\"name\":\"position\",\"type\":\"SENSOR\"}]"), array, false);
        slider.move(0);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/slider/cursor/position/GET", null, "GET");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals(0));
        slider.move(1);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/slider/cursor/position/GET", null, "GET");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals(1));
    }

    @Test
    public void testWsAccessMethodRawDescription() throws Exception {
        WsServiceTestClient client = new WsServiceTestClient();
        new Thread(client).start();
        String simulated = this.synchronizedRequest(client, "/sensinact/providers?rawDescribe=true", null);
        System.out.println(simulated);
        JSONArray response = new JSONArray("[\"slider\",\"light\"]");
        JSONAssert.assertEquals(response, new JSONArray(simulated), false);
    }

    @Test
    public void testWsAccessMethodGET(@InjectService(timeout=500L) SliderSetterItf slider) throws Exception {
        WsServiceTestClient client = new WsServiceTestClient();
        new Thread(client).start();
        String simulated = this.synchronizedRequest(client, "/sensinact/providers", null);
        System.out.println(simulated);
        JSONObject response = new JSONObject("{\"statusCode\":200,\"providers\":[\"slider\",\"light\"],\"type\":\"PROVIDERS_LIST\",\"uri\":\"/\"}");
        JSONAssert.assertEquals(response, new JSONObject(simulated), false);
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services", null);
        response = new JSONObject(simulated);
        JSONArray array = response.getJSONArray("services");
        Assertions.assertTrue((array.length() == 2 ? 1 : 0) != 0);
        JSONAssert.assertEquals(new JSONArray("[\"admin\",\"cursor\"]"), array, false);
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/cursor/resources", null);
        response = new JSONObject(simulated);
        array = response.getJSONArray("resources");
        JSONAssert.assertEquals(new JSONArray("[\"position\"]"), array, false);
        slider.move(1);
        Thread.sleep(1000L);
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/cursor/resources/position/GET", null);
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals(1));
        client.close();
    }

    @Test
    public void testSimplifiedWsAccessMethodGET(@InjectService(timeout=500L) SliderSetterItf slider) throws Exception {
        WsServiceTestClient client = new WsServiceTestClient();
        new Thread(client).start();
        String simulated = this.synchronizedRequest(client, "/sensinact/slider", null);
        JSONObject response = new JSONObject(simulated).getJSONObject("response");
        JSONArray array = response.getJSONArray("services");
        Assertions.assertTrue((array.length() == 2 ? 1 : 0) != 0);
        JSONAssert.assertEquals(new JSONArray("[\"admin\",\"cursor\"]"), array, false);
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/slider/cursor", null);
        response = new JSONObject(simulated).getJSONObject("response");
        array = response.getJSONArray("resources");
        JSONAssert.assertEquals(new JSONArray("[{\"name\":\"position\",\"type\":\"SENSOR\"}]"), array, false);
        slider.move(1);
        Thread.sleep(1000L);
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/slider/cursor/position/GET", null);
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/cursor/position"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals(1));
        client.close();
    }

    private String synchronizedRequest(WsServiceTestClient client, String url, String content) {
        String simulated = null;
        long wait = 10000L;
        client.newRequest(url, content);
        while (!client.isAvailable() && wait > 0L) {
            wait -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (client.isAvailable()) {
            simulated = client.getResponseMessage();
        }
        return simulated;
    }
}

