/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.nthbnd.rest.http.test.HttpServiceTestClient;
import org.eclipse.sensinact.gateway.nthbnd.rest.ws.test.WsServiceTestClient;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

@Extensions(value={@ExtendWith(value={BundleContextExtension.class}), @ExtendWith(value={ServiceExtension.class})})
public class TestRestSETAccess {
    @BeforeEach
    public void before(@InjectBundleContext BundleContext context) {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/admin/resources/location/SET", "{\"parameters\":[{\"name\": \"location\",\"value\": \"45.2:5.7\",\"type\": \"string\"}]}", "POST");
        JSONObject response = new JSONObject(simulated);
        Assertions.assertEquals((Object)200, (Object)response.get("statusCode"));
    }

    @Test
    public void testHttpAccessMethodSET(@InjectBundleContext BundleContext context) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/admin/resources/location/GET", null, "GET");
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/admin/location"));
        Assertions.assertEquals((Object)response.getJSONObject("response").get("value"), (Object)"45.2:5.7");
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/admin/resources/location/SET", "{\"parameters\":[{\"name\": \"location\",\"value\": \"0.0,0.0\",\"type\": \"string\"}]}", "POST");
        response = new JSONObject(simulated);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/slider/services/admin/resources/location/GET", null, "GET");
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/admin/location"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals("0.0,0.0"));
    }

    @Test
    public void testWsAccessMethodSET() throws Exception {
        WsServiceTestClient client = new WsServiceTestClient();
        new Thread(client).start();
        String simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/admin/resources/location/GET", null);
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/admin/location"));
        Assertions.assertEquals((Object)response.getJSONObject("response").get("value"), (Object)"45.2:5.7");
        simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/admin/resources/location/SET", "[{\"name\": \"location\",\"value\": \"0.0,0.0\",\"type\": \"string\"}]");
        response = new JSONObject(simulated);
        simulated = this.synchronizedRequest(client, "/sensinact/providers/slider/services/admin/resources/location/GET", null);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/slider/admin/location"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals("0.0,0.0"));
    }

    private String synchronizedRequest(WsServiceTestClient client, String url, String content) {
        String simulated = null;
        long wait = 10000L;
        client.newRequest(url, content);
        while (!client.isAvailable() && wait > 0L) {
            wait -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (client.isAvailable()) {
            simulated = client.getResponseMessage();
        }
        return simulated;
    }
}

