/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.SessionToken;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.http.HttpRestAccess;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.http.HttpRestAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(displayName="sensiNact")
public class HttpEndpoint
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEndpoint.class);
    private NorthboundMediator mediator;
    private Map<String, String> anonymous;

    public HttpEndpoint(NorthboundMediator mediator) {
        this.mediator = mediator;
        this.anonymous = new HashMap<String, String>();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getHeader("Accept") == null || !request.getHeader("Accept").contains("application/json") && !request.getHeader("Accept").contains("*/*")) {
            response.sendError(406, "Not Acceptable");
        }
        this.doExecute(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getContentType() == null || !request.getContentType().contains("application/json")) {
            response.sendError(415, "Unsupported Media Type");
        }
        if (request.getHeader("Accept") == null || !request.getHeader("Accept").contains("application/json") && !request.getHeader("Accept").contains("*/*")) {
            response.sendError(406, "Not Acceptable");
        }
        this.doExecute(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doExecute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        SessionToken authentication = null;
        String client = null;
        try {
            String clientAddress;
            String sid;
            HttpRestAccessRequest rar = new HttpRestAccessRequest(this.mediator, request);
            authentication = rar.getAuthentication();
            if (authentication == null && (sid = this.anonymous.get(client = (clientAddress = rar.getRemoteAddr()))) != null) {
                authentication = new SessionToken(sid);
                if (this.mediator.getNorthboundEndpoints().getEndpoint(new SessionToken(sid)) != null) {
                    rar.setAuthentication((Authentication<?>)authentication);
                }
            }
            HttpRestAccess restAccess = new HttpRestAccess(rar, new HttpServletResponseWrapper(response));
            restAccess.proceed();
        }
        catch (InvalidCredentialException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            response.sendError(401, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
            response.sendError(520, "Internal server error");
        }
        finally {
            String token = null;
            if (authentication == null && client != null && (token = response.getHeader("X-Auth-Token")) != null) {
                this.anonymous.put(client, token);
            }
        }
    }
}

