/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.http;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongPollingRecipient
extends NorthboundRecipient {
    private static final Logger LOG = LoggerFactory.getLogger(LongPollingRecipient.class);
    private HttpServletResponse response;

    public LongPollingRecipient(HttpServletResponse response, Mediator mediator) {
        super(mediator);
        this.response = response;
    }

    public void callback(String callbackId, SnaMessage<?>[] messages) {
        int length = messages == null ? 0 : messages.length;
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int index = 0; index < length; ++index) {
            builder.append(index == 0 ? "" : ",");
            builder.append(messages[index].getJSON());
        }
        builder.append(']');
        try {
            this.response.setStatus(200);
            this.response.getWriter().println(builder.toString());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

