/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundAccess;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestBuilder;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws.WebSocketConnection;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws.WsRestAccessRequest;
import org.json.JSONObject;

public class WsRestAccess
extends NorthboundAccess<WsRestAccessRequest> {
    private WebSocketConnection wsConnection;

    public WsRestAccess(WsRestAccessRequest request, WebSocketConnection wsConnection) throws IOException, InvalidCredentialException {
        super((NorthboundRequestWrapper)request);
        this.wsConnection = wsConnection;
    }

    protected boolean respond(NorthboundMediator mediator, NorthboundRequestBuilder builder) throws IOException {
        NorthboundRequest nthbndRequest = builder.build();
        if (nthbndRequest == null) {
            this.sendError(500, "Internal server error");
            return false;
        }
        AccessMethodResponse cap = this.wsConnection.getEndpoint().execute(nthbndRequest);
        if (cap == null) {
            this.sendError(500, "Internal server error");
            return false;
        }
        String result = null;
        List<String> rawList = null;
        List<String> acceptEncoding = null;
        Map<NorthboundRequestWrapper.QueryKey, List<String>> queryMap = ((WsRestAccessRequest)this.request).getQueryMap();
        for (NorthboundRequestWrapper.QueryKey queryKey : queryMap.keySet()) {
            if ("rawDescribe".equals(queryKey.name)) {
                rawList = queryMap.get(queryKey);
            }
            if (!"Accept-Encoding".equals(queryKey.name)) continue;
            acceptEncoding = queryMap.get(queryKey);
        }
        result = rawList != null && (rawList.contains("true") || rawList.contains("True") || rawList.contains("yes") || rawList.contains("Yes")) && DescribeResponse.class.isAssignableFrom(cap.getClass()) ? ((DescribeResponse)cap).getJSON(true) : cap.getJSON();
        try {
            byte[] resultBytes;
            if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
                resultBytes = NorthboundAccess.compress((String)result);
                this.wsConnection.send(resultBytes);
            } else {
                resultBytes = result.getBytes("UTF-8");
                this.wsConnection.send(new String(resultBytes));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return true;
    }

    protected void sendError(int i, String message) throws IOException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("statusCode", i);
        jsonObject.put("message", (Object)message);
        try {
            this.wsConnection.send(new String(jsonObject.toString().getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

