/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.protocol.http.Headers;

public class HeadersCollection
implements Headers {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public HeadersCollection() {
    }

    public HeadersCollection(Map<String, List<String>> headers) {
        this();
        this.addHeaders(headers);
    }

    @Override
    public Iterator<String> iterator() {
        return this.headers.keySet().iterator();
    }

    @Override
    public void addHeaders(Map<String, List<String>> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void addHeader(String header, String value) {
        List<String> headerValues = this.headers.get(header);
        if (headerValues == null) {
            headerValues = new ArrayList<String>();
            this.headers.put(header, headerValues);
        }
        headerValues.add(value);
    }

    @Override
    public void addHeader(String header, List<String> values) {
        List<String> headerValues = this.headers.get(header);
        if (headerValues == null) {
            headerValues = new ArrayList<String>();
            this.headers.put(header, headerValues);
        }
        headerValues.addAll(values);
    }

    @Override
    public List<String> getHeader(String header) {
        return Collections.unmodifiableList(this.headers.get(header));
    }

    @Override
    public String getHeaderAsString(String header) {
        List<String> list = this.headers.get(header);
        if (list == null) {
            return null;
        }
        int length = list.size();
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < length; ++index) {
            builder.append(index > 0 ? " " : "");
            builder.append(list.get(index));
        }
        return builder.toString();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String key : this) {
            builder.append("\n\t");
            builder.append(key);
            builder.append(":");
            builder.append(this.getHeaderAsString(key));
        }
        return builder.toString();
    }
}

