/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sensinact.gateway.protocol.http.HeadersCollection;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ProxyConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.protocol.http.client.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConnectionConfigurationImpl<RESPONSE extends Response, REQUEST extends Request<RESPONSE>>
extends HeadersCollection
implements ConnectionConfiguration<RESPONSE, REQUEST> {
    protected Object content;
    protected int readTimeout = -1;
    protected int connectTimeout = -1;
    protected String contentType;
    protected String acceptType;
    protected String uri;
    protected String httpMethod;
    private String serverCertificate;
    private String clientCertificate;
    private String clientCertificatePassword;
    protected ProxyConfiguration proxyConfiguration;
    protected Map<String, String> parameters = new HashMap<String, String>();

    public ConnectionConfigurationImpl() {
        this.proxyConfiguration = new ProxyConfiguration();
    }

    public ConnectionConfigurationImpl(String configuration) {
        this();
        int length;
        JSONObject jsonConfiguration = new JSONObject(configuration);
        this.uri = (String)jsonConfiguration.opt("uri");
        this.httpMethod = (String)jsonConfiguration.opt("httpMethod");
        this.content = jsonConfiguration.opt("content");
        this.acceptType = (String)jsonConfiguration.opt("acceptType");
        this.contentType = (String)jsonConfiguration.opt("contentType");
        Integer timeout = (Integer)jsonConfiguration.opt("connectTimeout");
        this.connectTimeout = timeout != null ? timeout : -1;
        timeout = (Integer)jsonConfiguration.opt("readTimeout");
        this.readTimeout = timeout != null ? timeout : -1;
        JSONArray params = jsonConfiguration.optJSONArray("parameters");
        int n = length = params == null ? 0 : params.length();
        for (int index = 0; index < length; ++index) {
            JSONObject object = params.optJSONObject(index);
            if (JSONObject.NULL.equals(object)) continue;
            this.queryParameter(object.optString("key"), object.optString("value"));
        }
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> queryParameter(String key, String value) {
        if (key != null && key.length() > 0 && value != null) {
            this.parameters.put(key, value);
        }
        return this;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setUri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String getUri() {
        if (!this.parameters.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.uri);
            Iterator<Map.Entry<String, String>> iterator = this.parameters.entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                builder.append(index == 0 ? "?" : "&");
                builder.append(entry.getKey());
                builder.append("=");
                builder.append(entry.getValue());
                ++index;
            }
            return builder.toString();
        }
        return this.uri;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setContent(Object content) {
        this.content = content;
        return this;
    }

    @Override
    public Object getContent() {
        return this.content;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setAccept(String acceptType) {
        this.acceptType = acceptType;
        return this;
    }

    @Override
    public String getAccept() {
        return this.acceptType;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Override
    public String getHttpMethod() {
        if (this.httpMethod == null) {
            return "GET";
        }
        return this.httpMethod;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public int getConnectTimeout() {
        if (this.connectTimeout <= 0) {
            return 5000;
        }
        return this.connectTimeout;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public int getReadTimeout() {
        if (this.readTimeout <= 0) {
            return 5000;
        }
        return this.readTimeout;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setProxyHost(String proxyHost) {
        this.proxyConfiguration.setProxyHost(proxyHost);
        return this;
    }

    @Override
    public ConnectionConfigurationImpl<RESPONSE, REQUEST> setProxyPort(int proxyPort) {
        this.proxyConfiguration.setProxyPort(proxyPort);
        return this;
    }

    @Override
    public void setServerSSLCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    @Override
    public String getServerSSLCertificate() {
        return this.serverCertificate;
    }

    @Override
    public void setClientSSLCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    @Override
    public String getClientSSLCertificate() {
        return this.clientCertificate;
    }

    @Override
    public String getClientSSLCertificatePassword() {
        return this.clientCertificatePassword;
    }

    @Override
    public void setClientSSLCertificatePassword(String clientCertificatePassword) {
        this.clientCertificatePassword = clientCertificatePassword;
    }

    @Override
    public Proxy getProxy() {
        return this.proxyConfiguration.getProxy();
    }

    @Override
    public HttpURLConnection connect() throws IOException {
        return ConnectionConfiguration.HttpURLConnectionBuilder.build(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HTTP ");
        builder.append(this.getHttpMethod());
        builder.append(" Request [");
        builder.append(this.getUri());
        builder.append("]");
        builder.append("\n\tContent-Type:");
        builder.append(this.getContentType());
        builder.append("\n\tAccept:");
        builder.append(this.getAccept());
        builder.append("\n\tConnection Timeout:");
        builder.append(this.getConnectTimeout());
        builder.append("\n\tRead Timeout:");
        builder.append(this.getReadTimeout());
        builder.append(super.toString());
        return builder.toString();
    }
}

