/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http.client;

import java.net.InetSocketAddress;
import java.net.Proxy;

public final class ProxyConfiguration {
    private static final int DEFAULT_HTTP_PORT = 80;
    private String proxyHost;
    private int proxyPort;

    public ProxyConfiguration() {
        int port;
        String httpProxy = System.getProperty("org.eclipse.sensinact.gateway.http.proxyHost");
        String httpPort = System.getProperty("org.eclipse.sensinact.gateway.http.proxyPort");
        if (httpPort != null) {
            try {
                port = Integer.parseInt(httpPort);
            }
            catch (NumberFormatException e) {
                port = 80;
            }
        } else {
            port = 80;
        }
        this.proxyHost = httpProxy;
        this.proxyPort = port;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Proxy getProxy() {
        if (this.proxyHost != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }
        return Proxy.NO_PROXY;
    }
}

