/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http.server;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.protocol.http.server.HttpRequestContent;
import org.eclipse.sensinact.gateway.protocol.http.server.RequestHandler;
import org.eclipse.sensinact.gateway.protocol.http.server.ResponseContent;
import org.eclipse.sensinact.gateway.util.IOUtils;

public class Server {
    private static Logger LOG = Logger.getLogger(Server.class.getName());
    private static final String ROOT_CONTEXT = "/";
    private static final int DEFAULT_PORT = 8789;
    private final HttpServer server;
    private final AtomicBoolean running;
    private int handled;
    private int binded;
    private RequestHandler requestHandler;

    public Server(RequestHandler requestHandler) throws IOException {
        this.requestHandler = requestHandler;
        this.server = HttpServer.create();
        this.server.setExecutor(null);
        this.running = new AtomicBoolean(false);
        this.handled = 0;
        this.binded = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void running(boolean running) {
        Server server = this;
        synchronized (server) {
            this.running.set(running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean running() {
        boolean running = false;
        Server server = this;
        synchronized (server) {
            running = this.running.get();
        }
        return running;
    }

    protected void handle() {
        this.handle(null);
    }

    protected void handle(String path) {
        if (path == null) {
            path = ROOT_CONTEXT;
        }
        HttpContext context = this.server.createContext(path);
        context.setHandler(new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                block4: {
                    int responseCode = !Server.this.running() ? 404 : 202;
                    Headers headers = httpExchange.getRequestHeaders();
                    URI uri = httpExchange.getRequestURI();
                    String method = httpExchange.getRequestMethod();
                    Map<String, Object> attributes = httpExchange.getHttpContext().getAttributes();
                    HttpRequestContent httpRequestContent = new HttpRequestContent(uri, method, headers);
                    int length = -1;
                    try {
                        length = Integer.parseInt(httpExchange.getResponseHeaders().getFirst("Content-Length"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    byte[] content = length > 0 ? IOUtils.read((InputStream)httpExchange.getRequestBody(), (int)length, (boolean)false) : IOUtils.read((InputStream)httpExchange.getRequestBody(), (boolean)false);
                    httpRequestContent.setContent(content);
                    ResponseContent response = Server.this.requestHandler.handle(httpRequestContent);
                    int code = responseCode;
                    length = response.getContent().length;
                    try {
                        httpExchange.sendResponseHeaders(code, length);
                        httpExchange.getResponseHeaders().putAll((Map<? extends String, ? extends List<String>>)response.getHeaders());
                        httpExchange.getResponseBody().write(response.getContent());
                        httpExchange.getResponseBody().flush();
                        httpExchange.getResponseBody().close();
                    }
                    catch (IOException e) {
                        code = 500;
                        if (!LOG.isLoggable(Level.SEVERE)) break block4;
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        });
        ++this.handled;
    }

    public void start() throws IOException {
        if (this.handled == 0) {
            this.handle();
        }
        if (this.binded == 0) {
            this.bind();
        }
        this.running(true);
        this.server.start();
    }

    protected void start(String clientURL) throws IOException {
        this.bind(new URL(clientURL));
        this.start();
    }

    protected void start(String ipAddress, int port) throws IOException {
        this.bind(ipAddress, port);
        this.start();
    }

    protected void bind() throws IOException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterface.isLoopback()) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                this.bind(inetAddress.getHostAddress(), 8789);
            }
        }
    }

    public void bind(URL url) throws IOException {
        InetAddress remote = InetAddress.getByName(url.getHost());
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!remote.isReachable(networkInterface, 0, 1000)) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                this.bind(inetAddress.getHostAddress(), 8789);
            }
        }
    }

    public void bind(String ipAddress, int port) throws IOException {
        this.server.bind(new InetSocketAddress(ipAddress, port), 0);
        ++this.binded;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "server binded on " + ipAddress + " / port " + port);
        }
    }

    public void stop() {
        this.running(false);
        this.server.stop(0);
    }
}

