/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.sensinact.gateway.protocol.http.test.Callback;
import org.eclipse.sensinact.gateway.protocol.http.test.CallbackCollection;
import org.eclipse.sensinact.gateway.protocol.http.test.JettyTestCallbackServlet;
import org.eclipse.sensinact.gateway.protocol.http.test.doGet;
import org.eclipse.sensinact.gateway.protocol.http.test.doPost;
import org.eclipse.sensinact.gateway.util.ReflectUtils;

public class JettyTestServer
implements Runnable,
CallbackCollection {
    private Server server;
    Map<Class<? extends Annotation>, List<Callback>> callbacks = new HashMap<Class<? extends Annotation>, List<Callback>>();
    private boolean running = false;

    public JettyTestServer(int port) throws Exception {
        this.server = new Server(port);
        ServletHandler handler = new ServletHandler();
        ServletHolder holder = new ServletHolder((Servlet)new JettyTestCallbackServlet(this));
        holder.setName("callbackServlet");
        handler.addServletWithMapping(holder, "/");
        this.server.setHandler((Handler)handler);
    }

    public void registerCallback(Object callback) {
        Map postMethods;
        Map getMethods = ReflectUtils.getAnnotatedMethods(callback.getClass(), doGet.class);
        if (getMethods != null && getMethods.size() > 0) {
            List<Callback> callbackList = this.callbacks.get(doGet.class);
            if (callbackList == null) {
                callbackList = new ArrayList<Callback>();
                this.callbacks.put(doGet.class, callbackList);
            }
            Iterator iterator = getMethods.keySet().iterator();
            while (iterator.hasNext()) {
                callbackList.add(new Callback(callback, (Method)iterator.next()));
            }
        }
        if ((postMethods = ReflectUtils.getAnnotatedMethods(callback.getClass(), doPost.class)) != null && postMethods.size() > 0) {
            List<Callback> callbackList = this.callbacks.get(doPost.class);
            if (callbackList == null) {
                callbackList = new ArrayList<Callback>();
                this.callbacks.put(doPost.class, callbackList);
            }
            Iterator iterator = postMethods.keySet().iterator();
            while (iterator.hasNext()) {
                callbackList.add(new Callback(callback, (Method)iterator.next()));
            }
        }
    }

    public boolean isStarted() {
        return this.running;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void join() throws Exception {
        this.server.join();
        Thread.sleep(2000L);
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = false;
    }

    @Override
    public List<Callback> getdoGetCallbacks() {
        return this.callbacks.get(doGet.class);
    }

    @Override
    public List<Callback> getdoPostCallbacks() {
        return this.callbacks.get(doPost.class);
    }
}

