/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http.test;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.eclipse.sensinact.gateway.protocol.http.client.mid.MidClient;
import org.eclipse.sensinact.gateway.protocol.http.client.mid.MidClientListener;
import org.eclipse.sensinact.gateway.protocol.http.client.mid.Reusable;
import org.eclipse.sensinact.gateway.protocol.http.test.JettyServerTestCallback;
import org.eclipse.sensinact.gateway.protocol.http.test.JettyTestServer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class TestHttpProtocolJetty {
    public static int HTTP_PORT = 8899;
    public static String HTTP_ROOTURL = "http://127.0.0.1:" + HTTP_PORT;
    private static JettyTestServer server = null;

    public static String newRequest(String configuration) throws IOException {
        ConnectionConfigurationImpl builder = new ConnectionConfigurationImpl(configuration);
        SimpleRequest request = new SimpleRequest((ConnectionConfiguration)builder);
        SimpleResponse response = (SimpleResponse)request.send();
        byte[] responseContent = response.getContent();
        String contentStr = responseContent == null ? null : new String(responseContent);
        return contentStr;
    }

    public static String newRequest(String url, String content, String method) {
        ConnectionConfigurationImpl builder = new ConnectionConfigurationImpl();
        builder.setUri(url);
        try {
            if (method.equals("GET")) {
                builder.setHttpMethod("GET");
            } else if (method.equals("POST")) {
                builder.setContentType("application/json");
                builder.setHttpMethod("POST");
                if (content != null && content.length() > 0) {
                    JSONObject jsonData = new JSONObject(content);
                    builder.setContent((Object)jsonData.toString());
                }
            } else {
                return null;
            }
            builder.setAccept("application/json");
            SimpleRequest request = new SimpleRequest((ConnectionConfiguration)builder);
            SimpleResponse response = (SimpleResponse)request.send();
            byte[] responseContent = response.getContent();
            String contentStr = responseContent == null ? null : new String(responseContent);
            return contentStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static JSONObject getExpected(URL url, String content, String method) {
        JSONObject requestDescription = new JSONObject();
        requestDescription.put("method", (Object)method);
        requestDescription.put("url", (Object)url.getPath());
        if (method.equals("POST")) {
            JSONObject message = new JSONObject(content);
            requestDescription.put("content-type", (Object)"application/json");
            requestDescription.put("content-length", content.length());
            requestDescription.put("message", (Object)message);
        }
        return requestDescription;
    }

    @BeforeAll
    public static void init() throws Exception {
        System.out.println("Starting Jetty server ...");
        server = new JettyTestServer(HTTP_PORT);
        new Thread(server).start();
        server.join();
        server.registerCallback(new JettyServerTestCallback());
    }

    @AfterAll
    public static void tearDown() throws Exception {
        System.out.println("Stopping Jetty server ...");
        server.stop();
        server.join();
    }

    @Test
    public void testHttpProtocolGet() throws Exception {
        JSONObject expected = TestHttpProtocolJetty.getExpected(new URL(HTTP_ROOTURL + "/providers"), null, "GET");
        String simulated = TestHttpProtocolJetty.newRequest(HTTP_ROOTURL + "/providers", null, "GET");
        JSONAssert.assertEquals(expected, new JSONObject(simulated), false);
        JSONObject configuration = new JSONObject();
        configuration.put("uri", (Object)(HTTP_ROOTURL + "/providers"));
        configuration.put("httpMethod", (Object)"GET");
        configuration.put("acceptType", (Object)"application/json");
        configuration.put("connectTimeout", 2000);
        configuration.put("readTimeout", 2000);
        simulated = TestHttpProtocolJetty.newRequest(configuration.toString());
        JSONAssert.assertEquals(expected, new JSONObject(simulated), false);
        StringBuilder builder = new StringBuilder();
        builder.append("HTTP ");
        builder.append("GET");
        builder.append(" Request [");
        builder.append(HTTP_ROOTURL + "/providers");
        builder.append("]");
        builder.append("\n\tContent-Type:");
        builder.append("null");
        builder.append("\n\tAccept:");
        builder.append("application/json");
        builder.append("\n\tConnection Timeout:");
        builder.append(2000);
        builder.append("\n\tRead Timeout:");
        builder.append(2000);
        ConnectionConfigurationImpl config = new ConnectionConfigurationImpl(configuration.toString());
        Assertions.assertEquals((Object)builder.toString(), (Object)config.toString());
        configuration.put("parameters", (Object)new JSONArray().put((Object)new JSONObject().put("key", (Object)"param1").put("value", (Object)"value1")).put((Object)new JSONObject().put("key", (Object)"param2").put("value", 5)));
        simulated = TestHttpProtocolJetty.newRequest(configuration.toString());
        JSONAssert.assertNotEquals(expected, new JSONObject(simulated), true);
        expected.remove("url");
        expected.put("url", (Object)"/providers?param1=value1&param2=5");
        JSONAssert.assertEquals(expected, new JSONObject(simulated), false);
    }

    @Test
    public void testHttpProtocolPost() throws Exception {
        String simulated = TestHttpProtocolJetty.newRequest(HTTP_ROOTURL + "/providers/slider/services/cursor/resources/position/SUBSCRIBE", "{\"parameters\" : [{\"name\":\"callback\", \"type\":\"string\",\"value\":\"http://127.0.0.1:8899/\"},{\"name\":\"conditions\",\"type\":\"array\",\"value\":[{\"operator\":\"<\",\"operand\":200, \"type\":\"int\", \"complement\":false}]}]}", "POST");
        JSONAssert.assertEquals(TestHttpProtocolJetty.getExpected(new URL(HTTP_ROOTURL + "/providers/slider/services/cursor/resources/position/SUBSCRIBE"), "{\"parameters\":[{\"name\":\"callback\",\"type\":\"string\",\"value\":\"http://127.0.0.1:8899/\"},{\"name\":\"conditions\",\"type\":\"array\",\"value\":[{\"operator\":\"<\",\"operand\":200,\"type\":\"int\",\"complement\":false}]}]}", "POST"), new JSONObject(simulated), false);
    }

    @Test
    public void testHttpMidClient() throws Exception {
        ClientListener listener = new ClientListener();
        MidClient client = new MidClient((MidClientListener)listener);
        client.setInitialDelay(200);
        client.setMaxDelay(1000);
        JSONObject configuration = new JSONObject();
        configuration.put("uri", (Object)(HTTP_ROOTURL + "/error"));
        configuration.put("httpMethod", (Object)"GET");
        configuration.put("acceptType", (Object)"*/*");
        configuration.put("connectTimeout", 2000);
        configuration.put("readTimeout", 2000);
        ConnectionConfigurationImpl builder = new ConnectionConfigurationImpl(configuration.toString());
        MidRequest request = new MidRequest((ConnectionConfiguration<SimpleResponse, SimpleRequest>)builder, true);
        Assertions.assertEquals((int)-1, (int)client.getCurrentDelay());
        client.addRequest((Request)request);
        listener.setAvailable(false);
        this.waitForAvailableMessage(listener, 5000L);
        Assertions.assertEquals((int)200, (int)client.getCurrentDelay());
        listener.setAvailable(false);
        this.waitForAvailableMessage(listener, 5000L);
        Assertions.assertEquals((int)400, (int)client.getCurrentDelay());
        listener.setAvailable(false);
        this.waitForAvailableMessage(listener, 5000L);
        Assertions.assertEquals((int)800, (int)client.getCurrentDelay());
        listener.setAvailable(false);
        this.waitForAvailableMessage(listener, 5000L);
        Assertions.assertEquals((int)1000, (int)client.getCurrentDelay());
        listener.setAvailable(false);
        this.waitForAvailableMessage(listener, 5000L);
        Assertions.assertEquals((int)1000, (int)client.getCurrentDelay());
        listener.setAvailable(false);
        this.waitForAvailableMessage(listener, 5000L);
        Assertions.assertEquals((int)1000, (int)client.getCurrentDelay());
        client.close();
    }

    private String waitForAvailableMessage(ClientListener client, long delay) {
        String message = null;
        long wait = delay;
        while (!client.isAvailable() && wait > 0L) {
            try {
                Thread.sleep(100L);
                wait -= 100L;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (client.isAvailable()) {
            message = client.getResponseMessage();
        }
        return message;
    }

    private class ClientListener
    implements MidClientListener<SimpleResponse> {
        private String message;
        private AtomicBoolean available = new AtomicBoolean(false);

        ClientListener() {
        }

        public void respond(SimpleResponse response) {
            this.message = response != null ? (response.getContent() == null ? "NO RESPONSE" : new String(response.getContent())) : "NO RESPONSE";
            this.setAvailable(true);
        }

        private void setAvailable(boolean available) {
            this.available.set(available);
        }

        public boolean isAvailable() {
            return this.available.get();
        }

        public String getResponseMessage() {
            return this.message;
        }
    }

    private class MidRequest
    extends SimpleRequest
    implements Reusable {
        private boolean reusable;

        public MidRequest(ConnectionConfiguration<SimpleResponse, SimpleRequest> configuration, boolean reusable) {
            super(configuration);
            this.reusable = reusable;
        }

        public boolean isReusable() {
            return this.reusable;
        }

        public MidRequest copy() {
            return new MidRequest((ConnectionConfiguration<SimpleResponse, SimpleRequest>)this.configuration, this.reusable);
        }
    }
}

