/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.protocol.http.HeadersCollection;
import org.eclipse.sensinact.gateway.protocol.http.client.Response;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleResponse
extends HeadersCollection
implements Response {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleResponse.class);
    private static final int BUFFER_SIZE = 65536;
    protected int responseCode = -1;
    protected byte[] content = null;
    protected File save = null;
    protected HttpURLConnection connection;
    protected List<Throwable> exceptions = new ArrayList<Throwable>();

    public SimpleResponse(HttpURLConnection connection) throws IOException {
        super(connection.getHeaderFields());
        this.responseCode = connection.getResponseCode();
        this.connection = connection;
    }

    private void addException(Exception e) {
        this.exceptions.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getContent() {
        if (this.content == null && this.connection != null) {
            int length;
            String contentLength = super.getHeaderAsString("Content-Length");
            try {
                length = contentLength == null ? 0 : Integer.parseInt(contentLength.trim());
            }
            catch (NumberFormatException e) {
                length = 0;
            }
            byte[] bytes = null;
            InputStream input = null;
            try {
                input = this.connection.getInputStream();
                bytes = length == 0 ? IOUtils.read((InputStream)input, (boolean)false) : IOUtils.read((InputStream)input, (int)length, (boolean)false);
                length = bytes == null ? 0 : bytes.length;
                this.content = bytes;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                    }
                    input = null;
                }
            }
            this.connection.disconnect();
            this.connection = null;
        }
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String save() {
        if (this.save == null && this.connection != null) {
            byte[] buffer = new byte[65536];
            File tmpFolder = null;
            FileOutputStream output = null;
            InputStream input = null;
            try {
                File tmpFile = File.createTempFile("response", ".tmp");
                tmpFile.delete();
                tmpFolder = tmpFile.getParentFile();
                String filename = String.format("res_%s_%s", this.connection.hashCode(), System.currentTimeMillis());
                File tmpsave = new File(tmpFolder, filename);
                output = new FileOutputStream(tmpsave);
                input = this.connection.getInputStream();
                while (true) {
                    int read;
                    if ((read = input.read(buffer)) < 0) {
                        this.save = tmpsave;
                        break;
                    }
                    output.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        this.connection.disconnect();
                        this.connection = null;
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (this.save == null) {
            return null;
        }
        String string = this.save.getAbsolutePath();
        return string;
    }

    public InputStream inputStream() {
        try {
            return this.connection.getInputStream();
        }
        catch (IOException | NullPointerException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public int getStatusCode() {
        return this.responseCode;
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }
}

