/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.sensinact.gateway.protocol.http.Headers;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.protocol.http.client.Response;
import org.eclipse.sensinact.gateway.util.IOUtils;

public interface ConnectionConfiguration<RESPONSE extends Response, REQUEST extends Request<RESPONSE>>
extends Headers {
    public static final Logger LOG = Logger.getLogger(ConnectionConfiguration.class.getName());
    public static final String READ_TIMEOUT = "Read-timeout";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String CONNECT_TIMEOUT = "Connect-timeout";
    public static final String CONTENT_TYPE = "Content-type";
    public static final String ACCEPT = "Accept";
    public static final String HTTP_METHOD = "httpMethod";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_ACCEPT = "text/html";
    public static final String DEFAULT_HTTP_METHOD = "GET";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    public static final String TRUST_ALL = "TRUST_ALL";
    public static final Map<String, TrustManager[]> TRUST_MANAGERS = new HashMap<String, TrustManager[]>();
    public static final Map<String, KeyManager[]> KEY_MANAGERS = new HashMap<String, KeyManager[]>();

    public ConnectionConfiguration<RESPONSE, REQUEST> queryParameter(String var1, String var2);

    public String getServerSSLCertificate();

    public void setServerSSLCertificate(String var1);

    public String getClientSSLCertificate();

    public void setClientSSLCertificate(String var1);

    public String getClientSSLCertificatePassword();

    public void setClientSSLCertificatePassword(String var1);

    public ConnectionConfiguration<RESPONSE, REQUEST> setUri(String var1);

    public String getUri();

    public ConnectionConfiguration<RESPONSE, REQUEST> setContent(Object var1);

    public Object getContent();

    public ConnectionConfiguration<RESPONSE, REQUEST> setAccept(String var1);

    public String getAccept();

    public ConnectionConfiguration<RESPONSE, REQUEST> setContentType(String var1);

    public String getContentType();

    public ConnectionConfiguration<RESPONSE, REQUEST> setHttpMethod(String var1);

    public String getHttpMethod();

    public ConnectionConfiguration<RESPONSE, REQUEST> setConnectTimeout(int var1);

    public int getConnectTimeout();

    public ConnectionConfiguration<RESPONSE, REQUEST> setReadTimeout(int var1);

    public int getReadTimeout();

    public ConnectionConfiguration<RESPONSE, REQUEST> setProxyHost(String var1);

    public ConnectionConfiguration<RESPONSE, REQUEST> setProxyPort(int var1);

    public Proxy getProxy();

    public HttpURLConnection connect() throws IOException;

    public static final class HttpURLConnectionBuilder {
        public static <RESPONSE extends Response, REQUEST extends Request<RESPONSE>> HttpURLConnection build(ConnectionConfiguration<RESPONSE, REQUEST> config) throws IOException {
            HttpURLConnection connection = null;
            String uri = config.getUri();
            if (uri == null || uri.length() == 0) {
                return null;
            }
            URL url = new URL(uri);
            Proxy proxy = config.getProxy();
            SSLContext sc = null;
            if (url.getProtocol().toLowerCase().equals("https")) {
                String clientCertURL;
                connection = (HttpsURLConnection)url.openConnection(proxy);
                String host = url.getHost();
                TrustManager[] trusteds = TRUST_MANAGERS.get(host);
                KeyManager[] keys = KEY_MANAGERS.get(host);
                if (trusteds == null) {
                    String serverCertificateStr = config.getServerSSLCertificate();
                    URL serverCertificate = null;
                    if (!ConnectionConfiguration.TRUST_ALL.equals(serverCertificateStr)) {
                        try {
                            serverCertificate = new URL(config.getServerSSLCertificate());
                        }
                        catch (IOException | NullPointerException e) {
                            LOG.log(Level.CONFIG, e.getMessage());
                        }
                    }
                    if (serverCertificate != null) {
                        try {
                            InputStream is = serverCertificate.openStream();
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
                            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                            ks.load(null);
                            ks.setCertificateEntry("caCert", cert);
                            tmf.init(ks);
                            trusteds = tmf.getTrustManagers();
                            TRUST_MANAGERS.put(host, trusteds);
                        }
                        catch (Exception e) {
                            trusteds = null;
                        }
                        if (trusteds == null && ConnectionConfiguration.TRUST_ALL.equals(serverCertificateStr)) {
                            trusteds = new TrustManager[]{new X509TrustManager(){

                                @Override
                                public X509Certificate[] getAcceptedIssuers() {
                                    return null;
                                }

                                @Override
                                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                                }

                                @Override
                                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                                }
                            }};
                        }
                    }
                }
                if (keys == null && (clientCertURL = config.getClientSSLCertificate()) != null) {
                    try {
                        URL clientCertificate = new URL(clientCertURL);
                        String password = config.getClientSSLCertificatePassword();
                        InputStream is = clientCertificate.openStream();
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        KeyStore ks = KeyStore.getInstance("PKCS12");
                        ks.load(is, password != null ? password.toCharArray() : new char[]{});
                        kmf.init(ks, password != null ? password.toCharArray() : new char[]{});
                        keys = kmf.getKeyManagers();
                        KEY_MANAGERS.put(host, keys);
                    }
                    catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                        keys = null;
                    }
                }
                try {
                    sc = SSLContext.getInstance("TLS");
                    sc.init(keys, trusteds, null);
                    ((HttpsURLConnection)connection).setSSLSocketFactory(sc.getSocketFactory());
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                    return null;
                }
            }
            connection = (HttpURLConnection)url.openConnection(proxy);
            connection.setConnectTimeout(config.getConnectTimeout());
            connection.setReadTimeout(config.getReadTimeout());
            connection.setDoInput(true);
            Object content = config.getContent();
            boolean doOutput = content != null;
            connection.setDoOutput(doOutput);
            connection.setRequestMethod(config.getHttpMethod());
            String contentType = null;
            contentType = config.getContentType();
            if (contentType != null) {
                connection.setRequestProperty(ConnectionConfiguration.CONTENT_TYPE, contentType);
            }
            String acceptType = null;
            acceptType = config.getAccept();
            if (acceptType != null) {
                connection.setRequestProperty(ConnectionConfiguration.ACCEPT, acceptType);
            }
            String data = doOutput ? String.valueOf(content) : null;
            for (String header : config) {
                connection.setRequestProperty(header, config.getHeaderAsString(header));
            }
            connection.connect();
            if (data != null) {
                IOUtils.write((byte[])data.getBytes(), (OutputStream)connection.getOutputStream());
            }
            return connection;
        }
    }

    public static abstract class BooleanProvider {
        abstract boolean init();
    }
}

