/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.ssdp.parser;

import org.eclipse.sensinact.gateway.protocol.ssdp.model.NotifyMessage;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.ResponseMessage;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPMessage;

public class SSDPDiscoveryParser {
    public static SSDPMessage parse(String message) {
        String[] content = message.split("\\r\\n");
        if (content[0].equals(SSDPMessage.RequestLine.RESPONSE.getRequestLine())) {
            ResponseMessage responseMessage = new ResponseMessage();
            for (int i = 1; i < content.length; ++i) {
                String[] splittedLine = content[i].split(":", 2);
                if (splittedLine.length <= 1) continue;
                String header = splittedLine[0];
                if (splittedLine[1] == null) continue;
                String value = splittedLine[1];
                if (header.equalsIgnoreCase("LOCATION")) {
                    responseMessage.setLocation(value.replace(" ", ""));
                    continue;
                }
                if (header.equalsIgnoreCase("USN")) {
                    responseMessage.setUsn(value.replace(" ", ""));
                    continue;
                }
                if (header.equalsIgnoreCase("CACHE-CONTROL")) {
                    if (!value.startsWith("max-age")) continue;
                    responseMessage.setMaxAge(new Integer(value.split("=")[1]));
                    continue;
                }
                if (header.equalsIgnoreCase("EXT")) {
                    responseMessage.setExt(value);
                    continue;
                }
                if (header.equalsIgnoreCase("ST")) {
                    responseMessage.setSt(value);
                    continue;
                }
                if (!header.equalsIgnoreCase("SERVER")) continue;
                responseMessage.setServer(value);
            }
            return responseMessage;
        }
        if (content[0].equals(SSDPMessage.RequestLine.NOTIFY.getRequestLine())) {
            NotifyMessage notifyMessage = new NotifyMessage();
            for (int i = 1; i < content.length; ++i) {
                String[] splittedLine = content[i].split(":", 2);
                if (splittedLine.length <= 1) continue;
                String header = splittedLine[0];
                if (splittedLine[1] == null) continue;
                String value = splittedLine[1];
                if (header.equalsIgnoreCase("LOCATION")) {
                    notifyMessage.setLocation(value.replace(" ", ""));
                    continue;
                }
                if (header.equalsIgnoreCase("USN")) {
                    notifyMessage.setUsn(value.replace(" ", ""));
                    continue;
                }
                if (header.equalsIgnoreCase("CACHE-CONTROL")) {
                    if (!value.startsWith("max-age")) continue;
                    notifyMessage.setMaxAge(new Integer(value.split("=")[1]));
                    continue;
                }
                if (header.equalsIgnoreCase("NTS")) {
                    notifyMessage.setEvent(value);
                    continue;
                }
                if (header.equalsIgnoreCase("NT")) {
                    notifyMessage.setNotificationType(value);
                    continue;
                }
                if (!header.equalsIgnoreCase("SERVER")) continue;
                notifyMessage.setServer(value);
            }
            return notifyMessage;
        }
        if (content[0].equals(SSDPMessage.RequestLine.MSEARCH.getRequestLine())) {
            // empty if block
        }
        return null;
    }
}

