/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.ssdp.parser;

import java.util.Stack;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPDescriptionPacket;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SSDPDescriptionHandler
extends DefaultHandler {
    private SSDPDescriptionPacket descriptionPacket;
    private Stack<String> elementStack = new Stack();
    private Stack<SSDPDescriptionPacket> descriptionStack = new Stack();

    @Override
    public void startDocument() throws SAXException {
        this.descriptionStack.push(new SSDPDescriptionPacket());
    }

    @Override
    public void endDocument() throws SAXException {
        this.descriptionPacket = this.descriptionStack.pop();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.elementStack.push(qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        SSDPDescriptionPacket packet;
        String value = new String(ch, start, length).trim();
        if (value.length() == 0) {
            return;
        }
        if ("friendlyName".equalsIgnoreCase(this.elementStack.peek())) {
            SSDPDescriptionPacket packet2 = this.descriptionStack.peek();
            packet2.setFriendlyName(value.replace(" ", "_"));
        } else if ("URLBase".equalsIgnoreCase(this.elementStack.peek())) {
            SSDPDescriptionPacket packet3 = this.descriptionStack.peek();
            packet3.setUrl(value.split(":")[1].replace("/", ""));
        } else if ("presentationURL".equalsIgnoreCase(this.elementStack.peek()) && value.startsWith("http") && (packet = this.descriptionStack.peek()).getUrl() == null) {
            packet.setUrl(value.split(":")[1].replace("/", ""));
        }
    }

    public SSDPDescriptionPacket getDescriptionPacket() {
        return this.descriptionPacket;
    }
}

