/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.ssdp.model;

import org.eclipse.sensinact.gateway.protocol.ssdp.api.SSDPEvent;
import org.eclipse.sensinact.gateway.protocol.ssdp.exception.InvalidParameterException;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPMessage;

public class MSearchMessage
extends SSDPMessage {
    private static final String NEW_LINE = "\r\n";
    private static final String MAN = "ssdp:discover";

    @Override
    public void setEvent(String event) {
        this.event = SSDPEvent.DISCOVER;
    }

    public static String createMessage(String st, int mx) throws InvalidParameterException {
        StringBuilder builder = new StringBuilder();
        if (mx < 1) {
            throw new InvalidParameterException("Maximum wait time MUST be greater or equal to 1");
        }
        builder.append(SSDPMessage.RequestLine.MSEARCH.getRequestLine());
        builder.append(NEW_LINE);
        builder.append("HOST: ");
        builder.append("239.255.255.250:1900");
        builder.append(NEW_LINE);
        builder.append("MAN: ");
        builder.append("\"ssdp:discover\"");
        builder.append(NEW_LINE);
        builder.append("MX: ");
        builder.append(mx);
        builder.append(NEW_LINE);
        builder.append("ST: ");
        builder.append(st);
        builder.append(NEW_LINE);
        builder.append(NEW_LINE);
        return builder.toString();
    }
}

