/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.ssdp.description;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPDescriptionPacket;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPReceivedMessage;
import org.eclipse.sensinact.gateway.protocol.ssdp.parser.SSDPDescriptionHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SSDPDescriptionRequest {
    public static SSDPDescriptionPacket getDescription(SSDPReceivedMessage packet) {
        String response = null;
        try {
            StringBuilder buffer;
            BufferedReader in;
            URL url = new URL(packet.getLocation());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/xml");
            if (connection.getResponseCode() == 200) {
                String inputLine;
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                buffer = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    buffer.append(inputLine);
                }
            } else {
                return null;
            }
            in.close();
            response = buffer.toString();
            connection.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response == null) {
            return null;
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            SSDPDescriptionHandler descriptionHandler = new SSDPDescriptionHandler();
            saxParser.parse(new InputSource(new ByteArrayInputStream(response.getBytes("utf-8"))), (DefaultHandler)descriptionHandler);
            return descriptionHandler.getDescriptionPacket();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return null;
    }
}

