/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.fan.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.simulated.fan.internal.FanConfigListener;

public class FanConfig {
    private List<FanConfigListener> listeners = new ArrayList<FanConfigListener>();
    private int speed = 10;
    private boolean on = false;

    public void addListener(FanConfigListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FanConfigListener listener) {
        this.listeners.remove(listener);
    }

    private void updateSpeed(int speed) {
        for (FanConfigListener listener : this.listeners) {
            listener.speedChanged(speed);
        }
    }

    public void turnOn() {
        this.on = true;
        this.updateSpeed(this.speed);
    }

    public void turnOff() {
        this.on = false;
        this.updateSpeed(0);
    }

    public void setSpeed(int speed) {
        this.speed = speed;
        if (this.on) {
            this.updateSpeed(this.speed);
        }
    }
}

