/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.fan.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.simulated.fan.internal.FanConfigListener;
import org.w3c.dom.Node;

public class FanPanel
extends JPanel
implements FanConfigListener {
    private static final long serialVersionUID = 1L;
    private static final int NUM_IMAGES = 11;
    private JFrame jFrame;
    private ImageIcon[] images = new ImageIcon[11];
    private Mediator mediator;
    private JLabel picture;

    public FanPanel(Mediator mediator) throws IOException {
        this.mediator = mediator;
        this.images[0] = this.readImgFromFile("images/fan/fan0.gif", 0);
        for (int i = 1; i < 11; ++i) {
            this.images[i] = this.readImgFromFile("images/fan/fan1.gif", i * 10);
        }
        this.jFrame = new JFrame("Simulated Fan");
        this.jFrame.setDefaultCloseOperation(0);
        this.jFrame.setResizable(false);
        this.jFrame.setTitle("fan");
        this.picture = new JLabel();
        this.picture.setHorizontalAlignment(0);
        this.picture.setAlignmentX(0.5f);
        this.picture.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.add(this.picture);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FanPanel.this.createAndShowGUI();
            }
        });
    }

    private ImageIcon readImgFromFile(String filename, int delay) {
        URL file = this.mediator.getContext().getBundle().getResource(filename);
        try {
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            reader.setInput(ImageIO.createImageInputStream(file.openStream()));
            int numImages = reader.getNumImages(true);
            IIOMetadata imageMetaData = reader.getImageMetadata(0);
            String metaFormatName = imageMetaData.getNativeMetadataFormatName();
            ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
            ImageOutputStream ios = ImageIO.createImageOutputStream(baoStream);
            ImageWriter writer = ImageIO.getImageWriter(reader);
            writer.setOutput(ios);
            writer.prepareWriteSequence(null);
            for (int i = 0; i < numImages; ++i) {
                BufferedImage frameIn = reader.read(i);
                IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(i).getAsTree(metaFormatName);
                if (delay > 0) {
                    int nNodes = root.getLength();
                    for (int j = 0; j < nNodes; ++j) {
                        Node node = root.item(j);
                        if (!node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) continue;
                        ((IIOMetadataNode)node).setAttribute("delayTime", Integer.toString(25 - 23 * delay / 100));
                    }
                }
                IIOMetadata metadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier(frameIn), null);
                metadata.setFromTree(metadata.getNativeMetadataFormatName(), root);
                IIOImage frameOut = new IIOImage(frameIn, null, metadata);
                writer.writeToSequence(frameOut, writer.getDefaultWriteParam());
            }
            writer.endWriteSequence();
            ios.seek(0L);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                while (true) {
                    bos.write(ios.readByte());
                }
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            Image image = Toolkit.getDefaultToolkit().createImage(bos.toByteArray());
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(image, 0);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException e) {
                image = null;
            }
            return new ImageIcon(image);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(104, 104);
    }

    @Override
    public void speedChanged(int imageNumber) {
        if (this.images[imageNumber] != null) {
            this.picture.setIcon(this.images[imageNumber]);
            this.picture.updateUI();
        } else {
            this.picture.setText("image #" + imageNumber + " not found");
            this.picture.updateUI();
        }
    }

    private void createAndShowGUI() {
        this.jFrame.getContentPane().add((Component)this, "Center");
        this.jFrame.pack();
        this.jFrame.setVisible(true);
        this.speedChanged(0);
    }

    public void stop() {
        this.jFrame.setVisible(false);
        this.jFrame.remove(this);
        this.jFrame.dispose();
    }
}

