/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.light.osgi;

import java.util.Collections;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.simulated.light.internal.LightConfig;
import org.eclipse.sensinact.gateway.simulated.light.swing.LightPanel;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleContext;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends AbstractActivator<Mediator> {
    private static final String GUI_ENABLED = "org.eclipse.sensinact.simulated.gui.enabled";
    private LocalProtocolStackEndpoint<Packet> connector;
    private LightConfig config;
    private LightPanel lightPanel;

    public void doStart() throws Exception {
        this.config = new LightConfig();
        ExtModelConfiguration manager = ExtModelConfigurationBuilder.instance((Mediator)this.mediator).withStartAtInitializationTime(true).build(new Object[]{"light-resource.xml", Collections.emptyMap()});
        this.connector = new LocalProtocolStackEndpoint(this.mediator);
        this.connector.addInjectableInstance(LightConfig.class, (Object)this.config);
        this.connector.connect(manager);
        if ("true".equals(this.mediator.getProperty(GUI_ENABLED))) {
            this.lightPanel = new LightPanel();
            this.config.addListener(this.lightPanel);
        }
    }

    public void doStop() throws Exception {
        this.connector.stop();
        this.connector = null;
        this.config.removeListener(this.lightPanel);
        if (this.lightPanel != null) {
            this.lightPanel.stop();
        }
    }

    public Mediator doInstantiate(BundleContext context) {
        return new Mediator(context);
    }
}

