/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.light.swing;

import java.awt.Component;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.eclipse.sensinact.gateway.simulated.light.internal.LightConfigListener;

public class LightPanel
extends JPanel
implements LightConfigListener {
    private static final long serialVersionUID = 1L;
    private JFrame jFrame;
    private static final int NUM_IMAGES = 11;
    ImageIcon[] images = new ImageIcon[11];
    JLabel picture;

    public LightPanel() {
        this.jFrame = new JFrame();
        this.jFrame.setDefaultCloseOperation(0);
        this.jFrame.setTitle("light");
        this.setLayout(new BoxLayout(this, 3));
        this.picture = new JLabel();
        this.picture.setHorizontalAlignment(0);
        this.picture.setAlignmentX(0.5f);
        this.picture.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.brightnessChanged(0);
        this.add(this.picture);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LightPanel.this.createAndShowGUI();
            }
        });
    }

    @Override
    public void brightnessChanged(int imageNumber) {
        if (this.images[imageNumber] == null) {
            this.images[imageNumber] = this.createImageIcon("/images/light/light" + imageNumber + ".png");
        }
        if (this.images[imageNumber] != null) {
            this.picture.setIcon(this.images[imageNumber]);
            this.picture.updateUI();
        } else {
            this.picture.setText("image #" + imageNumber + " not found");
            this.picture.updateUI();
        }
    }

    protected ImageIcon createImageIcon(String path) {
        URL imgURL = LightPanel.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.out.println("Couldn't find file: " + path);
        return null;
    }

    private void createAndShowGUI() {
        this.jFrame.add((Component)this, "Center");
        this.jFrame.pack();
        this.jFrame.setVisible(true);
    }

    public void stop() {
        this.jFrame.setVisible(false);
        this.jFrame.remove(this);
        this.jFrame.dispose();
    }
}

