/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.light.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.simulated.light.internal.LightConfigListener;

public class LightConfig {
    private List<LightConfigListener> listeners = new ArrayList<LightConfigListener>();
    private int brightness = 10;
    private boolean on = false;

    public void addListener(LightConfigListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LightConfigListener listener) {
        this.listeners.remove(listener);
    }

    private void updateBrightness(int brightness) {
        for (LightConfigListener listener : this.listeners) {
            listener.brightnessChanged(brightness);
        }
    }

    public void turnOn() {
        this.on = true;
        this.updateBrightness(this.brightness);
    }

    public void turnOff() {
        this.on = false;
        this.updateBrightness(0);
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
        if (this.on) {
            this.updateBrightness(brightness);
        }
    }
}

