/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import org.testcontainers.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.testcontainers.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.testcontainers.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import org.testcontainers.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.testcontainers.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import org.testcontainers.shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.testcontainers.shaded.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import org.testcontainers.shaded.org.bouncycastle.crypto.params.X448PublicKeyParameters;

public class X448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("X448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(this.random);
        X448PublicKeyParameters x448PublicKeyParameters = x448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x448PublicKeyParameters, x448PrivateKeyParameters);
    }
}

