/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.utility.DefaultImageNameSubstitutor;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestcontainersConfiguration;

public abstract class ImageNameSubstitutor
implements Function<DockerImageName, DockerImageName> {
    private static final Logger log = LoggerFactory.getLogger(ImageNameSubstitutor.class);
    @VisibleForTesting
    static ImageNameSubstitutor instance;
    @VisibleForTesting
    static ImageNameSubstitutor defaultImplementation;

    public static synchronized ImageNameSubstitutor instance() {
        if (instance == null) {
            String configuredClassName = TestcontainersConfiguration.getInstance().getImageSubstitutorClassName();
            if (configuredClassName != null) {
                ImageNameSubstitutor configuredInstance;
                log.debug("Attempting to instantiate an ImageNameSubstitutor with class: {}", (Object)configuredClassName);
                try {
                    configuredInstance = (ImageNameSubstitutor)Thread.currentThread().getContextClassLoader().loadClass(configuredClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Configured Image Substitutor could not be loaded: " + configuredClassName, e);
                }
                log.info("Found configured ImageNameSubstitutor: {}", (Object)configuredInstance.getDescription());
                instance = new ChainedImageNameSubstitutor(ImageNameSubstitutor.wrapWithLogging(defaultImplementation), ImageNameSubstitutor.wrapWithLogging(configuredInstance));
            } else {
                instance = ImageNameSubstitutor.wrapWithLogging(defaultImplementation);
            }
            log.info("Image name substitution will be performed by: {}", (Object)instance.getDescription());
        }
        return instance;
    }

    public static ImageNameSubstitutor noop() {
        return new NoopImageNameSubstitutor();
    }

    private static ImageNameSubstitutor wrapWithLogging(ImageNameSubstitutor wrappedInstance) {
        return new LogWrappedImageNameSubstitutor(wrappedInstance);
    }

    @Override
    public abstract DockerImageName apply(DockerImageName var1);

    protected abstract String getDescription();

    static {
        defaultImplementation = new DefaultImageNameSubstitutor();
    }

    private static class NoopImageNameSubstitutor
    extends ImageNameSubstitutor {
        private NoopImageNameSubstitutor() {
        }

        @Override
        public DockerImageName apply(DockerImageName original) {
            return original;
        }

        @Override
        protected String getDescription() {
            return "No-op substitutor";
        }
    }

    static class ChainedImageNameSubstitutor
    extends ImageNameSubstitutor {
        private final ImageNameSubstitutor defaultInstance;
        private final ImageNameSubstitutor configuredInstance;

        public ChainedImageNameSubstitutor(ImageNameSubstitutor defaultInstance, ImageNameSubstitutor configuredInstance) {
            this.defaultInstance = defaultInstance;
            this.configuredInstance = configuredInstance;
        }

        @Override
        public DockerImageName apply(DockerImageName original) {
            return this.defaultInstance.andThen(this.configuredInstance).apply(original);
        }

        @Override
        protected String getDescription() {
            return String.format("Chained substitutor of '%s' and then '%s'", this.defaultInstance.getDescription(), this.configuredInstance.getDescription());
        }

        public String toString() {
            return this.getDescription();
        }
    }

    static class LogWrappedImageNameSubstitutor
    extends ImageNameSubstitutor {
        @VisibleForTesting
        final ImageNameSubstitutor wrappedInstance;

        public LogWrappedImageNameSubstitutor(ImageNameSubstitutor wrappedInstance) {
            this.wrappedInstance = wrappedInstance;
        }

        @Override
        public DockerImageName apply(DockerImageName original) {
            DockerImageName replacementImage = this.wrappedInstance.apply(original);
            if (!replacementImage.equals(original)) {
                log.info("Using {} as a substitute image for {} (using image substitutor: {})", new Object[]{replacementImage.asCanonicalNameString(), original.asCanonicalNameString(), this.wrappedInstance.getDescription()});
                return replacementImage;
            }
            log.debug("Did not find a substitute image for {} (using image substitutor: {})", (Object)original.asCanonicalNameString(), (Object)this.wrappedInstance.getDescription());
            return original;
        }

        @Override
        protected String getDescription() {
            return this.wrappedInstance.getDescription();
        }
    }
}

