/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.factory.integration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.gateway.southbound.http.factory.integration.KeyToolUtils;
import org.eclipse.sensinact.gateway.southbound.http.factory.integration.RequestHandler;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class HttpDeviceFactorySSLTest {
    QueuedThreadPool threadPool;
    Server server;
    RequestHandler handler;
    int httpPort;
    static String trustJksPath;
    static String serverJksPath;
    static String clientJksPath;
    static Path tmpDir;
    @InjectService
    SensiNactSessionManager sessionManager;
    SensiNactSession session;
    BlockingQueue<ResourceDataNotification> queue;
    @InjectService
    ConfigurationAdmin configAdmin;

    @BeforeAll
    static void setup() throws Exception {
        tmpDir = Files.createTempDirectory("sensinact-http", new FileAttribute[0]);
        KeyToolUtils kt = new KeyToolUtils();
        String caJksPath = tmpDir.resolve("ca.jks").toFile().getAbsolutePath();
        trustJksPath = tmpDir.resolve("trust.jks").toFile().getAbsolutePath();
        serverJksPath = tmpDir.resolve("server.jks").toFile().getAbsolutePath();
        clientJksPath = tmpDir.resolve("client.jks").toFile().getAbsolutePath();
        File caPemFile = tmpDir.resolve("ca.pem").toFile();
        File serverCrsFile = tmpDir.resolve("server.crs").toFile();
        File serverPemFile = tmpDir.resolve("server.pem").toFile();
        Path combinedServerPemPath = tmpDir.resolve("ca_server.pem");
        File clientCrsFile = tmpDir.resolve("client.crs").toFile();
        File clientPemFile = tmpDir.resolve("client.pem").toFile();
        Path combinedClientPemPath = tmpDir.resolve("ca_client.pem");
        kt.runTool("-genkeypair", "-keyalg", "RSA", "-keysize", "2048", "-validity", "5", "-alias", "ca", "-dname", "CN=CA,O=sensinact,OU=test", "-keystore", caJksPath, "-storepass", "password", "-ext", "KeyUsage=digitalSignature,keyCertSign", "-ext", "BasicConstraints=ca:true,PathLen:3");
        kt.runTool(null, ProcessBuilder.Redirect.to(caPemFile), "-exportcert", "-rfc", "-alias", "ca", "-keystore", caJksPath, "-storepass", "password");
        kt.runTool(ProcessBuilder.Redirect.from(caPemFile), null, "-importcert", "-alias", "ca", "-noprompt", "-keystore", trustJksPath, "-storepass", "password");
        kt.runTool("-genkeypair", "-keyalg", "RSA", "-keysize", "2048", "-validity", "5", "-alias", "server", "-dname", "CN=localhost,O=sensinact,OU=test", "-keystore", serverJksPath, "-storepass", "password", "-ext", "SubjectAlternativeName:c=DNS:localhost,IP:127.0.0.1");
        kt.runTool(null, ProcessBuilder.Redirect.to(serverCrsFile), "-certreq", "-alias", "server", "-storepass", "password", "-keystore", serverJksPath);
        kt.runTool(ProcessBuilder.Redirect.from(serverCrsFile), ProcessBuilder.Redirect.to(serverPemFile), "-gencert", "-alias", "ca", "-rfc", "-keystore", caJksPath, "-storepass", "password");
        kt.runTool(ProcessBuilder.Redirect.from(caPemFile), null, "-importcert", "-alias", "ca", "-noprompt", "-keystore", serverJksPath, "-storepass", "password");
        try (OutputStream out = Files.newOutputStream(combinedServerPemPath, StandardOpenOption.CREATE);){
            Files.copy(Paths.get(caPemFile.getPath(), new String[0]), out);
            Files.copy(Paths.get(serverPemFile.getPath(), new String[0]), out);
        }
        kt.runTool(ProcessBuilder.Redirect.from(combinedServerPemPath.toFile()), null, "-importcert", "-alias", "server", "-keystore", serverJksPath, "-storepass", "password");
        kt.runTool("-genkeypair", "-keyalg", "RSA", "-keysize", "2048", "-validity", "5", "-alias", "client", "-dname", "CN=client,O=sensinact", "-keystore", clientJksPath, "-storepass", "password");
        kt.runTool(null, ProcessBuilder.Redirect.to(clientCrsFile), "-certreq", "-alias", "client", "-keystore", clientJksPath, "-storepass", "password");
        kt.runTool(ProcessBuilder.Redirect.from(clientCrsFile), ProcessBuilder.Redirect.to(clientPemFile), "-gencert", "-alias", "ca", "-rfc", "-keystore", caJksPath, "-storepass", "password");
        kt.runTool(ProcessBuilder.Redirect.from(caPemFile), null, "-importcert", "-alias", "ca", "-noprompt", "-keystore", clientJksPath, "-storepass", "password");
        out = Files.newOutputStream(combinedClientPemPath, StandardOpenOption.CREATE);
        try {
            Files.copy(Paths.get(caPemFile.getPath(), new String[0]), out);
            Files.copy(Paths.get(clientPemFile.getPath(), new String[0]), out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        kt.runTool(ProcessBuilder.Redirect.from(combinedClientPemPath.toFile()), null, "-importcert", "-alias", "client", "-keystore", clientJksPath, "-storepass", "password");
    }

    @AfterAll
    static void teardown() throws Exception {
        Files.walk(tmpDir, new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
        Files.delete(tmpDir);
    }

    @BeforeEach
    void start() throws InterruptedException {
        this.session = this.sessionManager.getDefaultSession(UserInfo.ANONYMOUS);
        this.queue = new ArrayBlockingQueue<ResourceDataNotification>(32);
    }

    @AfterEach
    void stop() throws Exception {
        this.session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)this.session).removeListener(arg_0));
        this.session = null;
        this.stopServer();
    }

    void startServer(boolean withClientAuth) throws Exception {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(serverJksPath);
        sslContextFactory.setKeyStorePassword("password");
        if (withClientAuth) {
            sslContextFactory.setTrustStorePath(trustJksPath);
            sslContextFactory.setTrustStorePassword("password");
            sslContextFactory.setNeedClientAuth(true);
        }
        SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, http11.getProtocol());
        this.threadPool = new QueuedThreadPool();
        this.threadPool.setName("server");
        this.server = new Server((ThreadPool)this.threadPool);
        ServerConnector conn = new ServerConnector(this.server, new ConnectionFactory[]{tls, http11});
        conn.setPort(0);
        this.server.addConnector((Connector)conn);
        this.handler = new RequestHandler();
        this.server.setHandler((Handler)this.handler);
        this.server.start();
        this.httpPort = conn.getLocalPort();
    }

    void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        if (this.threadPool != null) {
            this.threadPool.stop();
            this.threadPool = null;
        }
        if (this.handler != null) {
            this.handler.clear();
        }
    }

    String readFile(String filename) throws IOException {
        try (InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("/" + filename);){
            String string = new String(inStream.readAllBytes());
            return string;
        }
    }

    String readData(String filename, String toReplace, String replaceBy) throws IOException {
        String content = this.readFile(filename);
        if (toReplace != null) {
            return content.replace(toReplace, replaceBy);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testRejectUntrusted() throws Exception {
        this.startServer(false);
        String provider1 = "ssl-reject-provider1";
        this.session.addListener(List.of("ssl-reject-provider1/*"), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.session.describeProvider("ssl-reject-provider1"));
        String inputFileName = "csv-header-typed";
        String mappingConfig = new String(this.readFile("csv-header-typed-mapping.json"));
        this.handler.setData("/data", this.readFile("csv-header-typed.csv").replace("typed-provider", "ssl-reject-provider"));
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.oneshot", "[{\"url\": \"https://localhost:" + this.httpPort + "/data\", \"mapping\": " + mappingConfig + "}]")));
            Assertions.assertNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)0, (int)this.handler.nbVisitedPaths());
        }
        finally {
            config.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testAllowUntrusted() throws Exception {
        this.startServer(false);
        String provider1 = "ssl-allowed-provider1";
        this.session.addListener(List.of("ssl-allowed-provider1/*"), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.session.describeProvider("ssl-allowed-provider1"));
        String inputFileName = "csv-header-typed";
        String mappingConfig = new String(this.readFile("csv-header-typed-mapping.json"));
        this.handler.setData("/data", this.readData("csv-header-typed.csv", "typed-provider", "ssl-allowed-provider"));
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.oneshot", "[{\"url\": \"https://localhost:" + this.httpPort + "/data\", \"ssl.ignoreErrors\": true, \"mapping\": " + mappingConfig + "}]")));
            Assertions.assertNotNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)42, (Integer)((Integer)this.session.getResourceValue("ssl-allowed-provider1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)1, (int)this.handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)this.handler.nbVisits("/data"));
        }
        finally {
            config.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testTrusted() throws Exception {
        this.startServer(false);
        String provider1 = "ssl-trusted-provider1";
        this.session.addListener(List.of("ssl-trusted-provider1/*"), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.session.describeProvider("ssl-trusted-provider1"));
        String inputFileName = "csv-header-typed";
        String mappingConfig = new String(this.readFile("csv-header-typed-mapping.json"));
        this.handler.setData("/data", this.readData("csv-header-typed.csv", "typed-provider", "ssl-trusted-provider"));
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.oneshot", "[{\"url\": \"https://localhost:" + this.httpPort + "/data\", \"ssl.ignoreErrors\": false, \"ssl.truststore\": \"" + Paths.get(trustJksPath, new String[0]).toUri().toASCIIString() + "\", \"ssl.truststore.password\": \"password\", \"mapping\": " + mappingConfig + "}]")));
            Assertions.assertNotNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)42, (Integer)((Integer)this.session.getResourceValue("ssl-trusted-provider1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)1, (int)this.handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)this.handler.nbVisits("/data"));
        }
        finally {
            config.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testClientAuthFailure() throws Exception {
        this.startServer(true);
        String provider1 = "ssl-client-auth-fail-provider1";
        this.session.addListener(List.of("ssl-client-auth-fail-provider1/*"), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.session.describeProvider("ssl-client-auth-fail-provider1"));
        String inputFileName = "csv-header-typed";
        String mappingConfig = new String(this.readFile("csv-header-typed-mapping.json"));
        this.handler.setData("/data", this.readData("csv-header-typed.csv", "typed-provider", "ssl-client-auth-fail-provider"));
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.oneshot", "[{\"url\": \"https://localhost:" + this.httpPort + "/data\", \"ssl.ignoreErrors\": false, \"ssl.truststore\": \"" + Paths.get(trustJksPath, new String[0]).toUri().toASCIIString() + "\", \"ssl.truststore.password\": \"password\", \"mapping\": " + mappingConfig + "}]")));
            Assertions.assertNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)0, (int)this.handler.nbVisitedPaths());
        }
        finally {
            config.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testClientAuthValid() throws Exception {
        this.startServer(true);
        String provider1 = "ssl-client-auth-valid-provider1";
        this.session.addListener(List.of("ssl-client-auth-valid-provider1/*"), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.session.describeProvider("ssl-client-auth-valid-provider1"));
        String inputFileName = "csv-header-typed";
        String mappingConfig = new String(this.readFile("csv-header-typed-mapping.json"));
        this.handler.setData("/data", this.readData("csv-header-typed.csv", "typed-provider", "ssl-client-auth-valid-provider"));
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.oneshot", "[{\"url\": \"https://localhost:" + this.httpPort + "/data\", \"ssl.ignoreErrors\": false, \"ssl.truststore\": \"" + Paths.get(trustJksPath, new String[0]).toUri().toASCIIString() + "\", \"ssl.truststore.password\": \"password\", \"ssl.keystore\": \"" + Paths.get(clientJksPath, new String[0]).toUri().toASCIIString() + "\", \"ssl.keystore.password\": \"password\", \"mapping\": " + mappingConfig + "}]")));
            Assertions.assertNotNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)42, (Integer)((Integer)this.session.getResourceValue("ssl-client-auth-valid-provider1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)1, (int)this.handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)this.handler.nbVisits("/data"));
        }
        finally {
            config.delete();
        }
    }
}

