/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.factory;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.sensinact.gateway.southbound.http.factory.ParsedHttpTask;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={SharedHttpClientResources.class})
public class SharedHttpClientResources {
    private QueuedThreadPool sharedPool;
    private Scheduler sharedScheduler;
    private SocketAddressResolver.Async sharedAddressResolver;

    @Activate
    void activate() throws Exception {
        String baseName = "sensinact-http-device-factory";
        this.sharedPool = new QueuedThreadPool(32);
        this.sharedPool.setName("sensinact-http-device-factory-pool");
        this.sharedPool.start();
        this.sharedScheduler = new ScheduledExecutorScheduler("sensinact-http-device-factory-scheduler", false);
        this.sharedScheduler.start();
        this.sharedAddressResolver = new SocketAddressResolver.Async((Executor)this.sharedPool, this.sharedScheduler, 15000L);
    }

    @Deactivate
    void deactivate() throws Exception {
        this.sharedScheduler.stop();
        this.sharedScheduler = null;
        this.sharedPool.stop();
        this.sharedPool = null;
        this.sharedAddressResolver = null;
    }

    public HttpClient newClient(ParsedHttpTask task) {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(task.ignoreSslErrors);
        if (task.keystorePath != null) {
            sslContextFactory.setKeyStorePath(task.keystorePath);
            if (task.keystorePassword != null) {
                sslContextFactory.setKeyStorePassword(task.keystorePassword);
            }
        }
        if (task.trustStorePath != null) {
            sslContextFactory.setTrustStorePath(task.trustStorePath);
            if (task.trustStorePassword != null) {
                sslContextFactory.setTrustStorePassword(task.trustStorePassword);
            }
        }
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setExecutor((Executor)this.sharedPool);
        clientConnector.setScheduler(this.sharedScheduler);
        clientConnector.setSslContextFactory(sslContextFactory);
        clientConnector.setConnectTimeout(Duration.of(task.timeout, ChronoUnit.SECONDS));
        HttpClient client = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
        client.setSocketAddressResolver((SocketAddressResolver)this.sharedAddressResolver);
        client.setFollowRedirects(task.followHttpRedirect);
        return client;
    }
}

