/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.virtual.temperature.integration;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.annotation.bundle.Requirement;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
@Requirement(namespace="osgi.service", filter="(objectClass=org.eclipse.sensinact.northbound.session.SensiNactSessionManager)")
public class TemperatureSensorTest {
    private static final UserInfo USER = UserInfo.ANONYMOUS;
    @InjectService
    SensiNactSessionManager sessionManager;

    @AfterEach
    void stop() {
        SensiNactSession session = this.sessionManager.getDefaultSession(USER);
        session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)session).removeListener(arg_0));
    }

    @Test
    void basicSubscribe(@InjectService ConfigurationAdmin configAdmin) throws Exception {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(32);
        SensiNactSession session = this.sessionManager.getDefaultSession(USER);
        session.addListener(List.of("*"), (t, e) -> queue.offer(e), null, null, null);
        Configuration config = configAdmin.createFactoryConfiguration("sensinact.virtual.temperature", "?");
        config.update(new Hashtable<String, Long>(Map.of("name", "temp1", "latitude", 1.0, "longitude", 2.0, "interval", 1000L)));
        ResourceDataNotification notification = (ResourceDataNotification)queue.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)"temp1", (Object)notification.provider);
        Assertions.assertEquals((Object)ProviderPackage.Literals.PROVIDER__ADMIN.getName(), (Object)notification.service);
        Assertions.assertEquals((Object)ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), (Object)notification.resource);
        notification = (ResourceDataNotification)queue.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)"temp1", (Object)notification.provider);
        Assertions.assertEquals((Object)ProviderPackage.Literals.PROVIDER__ADMIN.getName(), (Object)notification.service);
        Assertions.assertEquals((Object)ProviderPackage.Literals.ADMIN__LOCATION.getName(), (Object)notification.resource);
        Assertions.assertNull((Object)notification.oldValue);
        Assertions.assertInstanceOf(Point.class, (Object)notification.newValue);
        Point p = (Point)notification.newValue;
        Assertions.assertEquals((double)1.0, (double)p.coordinates.latitude);
        Assertions.assertEquals((double)2.0, (double)p.coordinates.longitude);
        notification = (ResourceDataNotification)queue.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)"temp1", (Object)notification.provider);
        Assertions.assertEquals((Object)ProviderPackage.Literals.PROVIDER__ADMIN.getName(), (Object)notification.service);
        Assertions.assertEquals((Object)ProviderPackage.Literals.ADMIN__MODEL.getName(), (Object)notification.resource);
        notification = (ResourceDataNotification)queue.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)"temp1", (Object)notification.provider);
        Assertions.assertEquals((Object)ProviderPackage.Literals.PROVIDER__ADMIN.getName(), (Object)notification.service);
        Assertions.assertEquals((Object)ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName(), (Object)notification.resource);
        notification = (ResourceDataNotification)queue.poll(100L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)"temp1", (Object)notification.provider);
        Assertions.assertEquals((Object)"sensor", (Object)notification.service);
        Assertions.assertEquals((Object)"temperature", (Object)notification.resource);
        Double value = (Double)notification.newValue;
        Assertions.assertEquals((double)15.0, (double)value, (double)15.0);
        Assertions.assertTrue((boolean)queue.isEmpty());
        notification = (ResourceDataNotification)queue.poll(1100L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)"temp1", (Object)notification.provider);
        Assertions.assertEquals((Object)"sensor", (Object)notification.service);
        Assertions.assertEquals((Object)"temperature", (Object)notification.resource);
        Assertions.assertEquals((Object)value, (Object)notification.oldValue);
        value = (Double)notification.newValue;
        Assertions.assertEquals((double)15.0, (double)value, (double)15.0);
        Assertions.assertNull(queue.poll(500L, TimeUnit.MILLISECONDS));
        notification = (ResourceDataNotification)queue.poll(600L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)"temp1", (Object)notification.provider);
        Assertions.assertEquals((Object)"sensor", (Object)notification.service);
        Assertions.assertEquals((Object)"temperature", (Object)notification.resource);
        Assertions.assertEquals((Object)value, (Object)notification.oldValue);
        value = (Double)notification.newValue;
        Assertions.assertEquals((double)15.0, (double)value, (double)15.0);
    }
}

