/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.device.factory.parser.csv;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.sensinact.gateway.southbound.device.factory.EncodingUtils;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingParser;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingRecord;
import org.eclipse.sensinact.gateway.southbound.device.factory.ParserException;
import org.eclipse.sensinact.gateway.southbound.device.factory.parser.csv.CsvRecord;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IDeviceMappingParser.class}, property={"sensinact.southbound.mapping.parser=csv"})
public class CsvParser
implements IDeviceMappingParser {
    public List<? extends IDeviceMappingRecord> parseRecords(byte[] rawInput, Map<String, Object> parserConfiguration, Map<String, String> context) throws ParserException {
        Boolean withHeader;
        String strEncoding = (String)parserConfiguration.get("encoding");
        Charset charset = strEncoding != null && !strEncoding.isBlank() ? Charset.forName(strEncoding) : StandardCharsets.UTF_8;
        InputStream input = StandardCharsets.UTF_8.equals(charset) && rawInput.length > 3 ? EncodingUtils.removeBOM((byte[])rawInput) : new ByteArrayInputStream(rawInput);
        CSVFormat.Builder format = CSVFormat.DEFAULT.builder();
        String delimiter = (String)parserConfiguration.get("delimiter");
        if (delimiter != null) {
            format = "\\t".equals(delimiter) ? format.setDelimiter("\t") : format.setDelimiter(delimiter);
        }
        if ((withHeader = (Boolean)parserConfiguration.get("header")) != null && withHeader.booleanValue()) {
            format = format.setHeader(new String[0]).setSkipHeaderRecord(true);
        }
        ArrayList<CsvRecord> records = new ArrayList<CsvRecord>();
        try (CSVParser parser = format.build().parse((Reader)new InputStreamReader(input, charset));){
            for (CSVRecord record : parser) {
                records.add(new CsvRecord(record, withHeader != null && withHeader == false));
            }
        }
        catch (IOException | IllegalStateException e) {
            throw new ParserException("Error reading CSV content", (Throwable)e);
        }
        return records;
    }
}

